/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.common.base.Strings;
import com.google.protobuf.Struct;
import com.spotify.confidence.ConfidenceUtils;
import com.spotify.confidence.FlagResolver;
import com.spotify.confidence.GrpcUtil;
import com.spotify.confidence.shaded.flags.resolver.v1.FlagResolverServiceGrpc;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsRequest;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsResponse;
import com.spotify.confidence.shaded.flags.resolver.v1.Sdk;
import com.spotify.confidence.shaded.flags.resolver.v1.SdkId;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class GrpcFlagResolver
implements FlagResolver {
    private final ManagedChannel managedChannel;
    private final String clientSecret;
    private final Sdk.Builder sdkBuilder = Sdk.newBuilder().setVersion(ConfidenceUtils.getSdkVersion());
    private final FlagResolverServiceGrpc.FlagResolverServiceFutureStub stub;

    public GrpcFlagResolver(String clientSecret, ManagedChannel managedChannel) {
        if (Strings.isNullOrEmpty((String)clientSecret)) {
            throw new IllegalArgumentException("clientSecret must be a non-empty string.");
        }
        this.clientSecret = clientSecret;
        this.managedChannel = managedChannel;
        this.stub = FlagResolverServiceGrpc.newFutureStub((Channel)managedChannel);
    }

    @Override
    public CompletableFuture<ResolveFlagsResponse> resolve(String flag, Struct context, Boolean isProvider) {
        return GrpcUtil.toCompletableFuture(((FlagResolverServiceGrpc.FlagResolverServiceFutureStub)this.stub.withDeadlineAfter(10L, TimeUnit.SECONDS)).resolveFlags(ResolveFlagsRequest.newBuilder().setClientSecret(this.clientSecret).addAllFlags(List.of(flag)).setEvaluationContext(context).setSdk(this.sdkBuilder.setId(isProvider != false ? SdkId.SDK_ID_JAVA_PROVIDER : SdkId.SDK_ID_JAVA_CONFIDENCE).build()).setApply(true).build()));
    }

    @Override
    public void close() {
        this.managedChannel.shutdownNow();
    }
}

