/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

final class GrpcUtil {
    private GrpcUtil() {
    }

    static <T> CompletableFuture<T> toCompletableFuture(final ListenableFuture<T> listenableFuture) {
        final CompletableFuture completableFuture = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                listenableFuture.cancel(mayInterruptIfRunning);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                completableFuture.complete(result);
            }

            public void onFailure(Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return completableFuture;
    }
}

