/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.spotify.confidence.Confidence;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.ErrorType;
import com.spotify.confidence.FlagEvaluation;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidenceStub
extends Confidence {
    private final Map<String, Object> valueMap = new HashMap<String, Object>();
    private final Map<String, FlagEvaluationConfig> evaluationConfigMap = new HashMap<String, FlagEvaluationConfig>();
    private static final Logger log = LoggerFactory.getLogger(ConfidenceStub.class);
    private final List<String> callHistory = new ArrayList<String>();

    private ConfidenceStub() {
    }

    public static ConfidenceStub createStub() {
        return new ConfidenceStub();
    }

    @Override
    protected Confidence.ClientDelegate client() {
        return new MockClientDelegate();
    }

    @Override
    public <T> T getValue(String key, T defaultValue) {
        if (this.valueMap.containsKey(key)) {
            Object value = this.valueMap.get(key);
            if (defaultValue != null && defaultValue.getClass().isInstance(value)) {
                return (T)value;
            }
            log.warn("Type mismatch for key: " + key);
        }
        return defaultValue;
    }

    @Override
    public Confidence withContext(ConfidenceValue.Struct context) {
        return this;
    }

    @Override
    public Confidence withContext(Map<String, ConfidenceValue> context) {
        return this;
    }

    @Override
    public <T> CompletableFuture<T> getValueFuture(String key, T defaultValue) {
        return CompletableFuture.completedFuture(this.getValue(key, defaultValue));
    }

    @Override
    public <T> CompletableFuture<FlagEvaluation<T>> getEvaluationFuture(String key, T defaultValue) {
        return CompletableFuture.completedFuture(this.getEvaluation(key, defaultValue));
    }

    @Override
    public <T> FlagEvaluation<T> getEvaluation(String key, T defaultValue) {
        T value = this.getValue(key, defaultValue);
        FlagEvaluationConfig config = this.evaluationConfigMap.getOrDefault(key, new FlagEvaluationConfig("stub", "MOCK", null, null));
        if (config.errorType == null && config.errorMessage == null) {
            return new FlagEvaluation<T>(value, config.variant, config.reason);
        }
        return new FlagEvaluation<T>(value, config.variant, config.reason, config.errorType, config.errorMessage);
    }

    @Override
    public void track(String eventName) {
        this.logCall("track", eventName);
    }

    @Override
    public void track(String eventName, ConfidenceValue.Struct data) {
        this.logCall("track", eventName, data);
    }

    @Override
    public void close() {
        this.logCall("close", new Object[0]);
    }

    @Override
    public void flush() {
        this.logCall("flush", new Object[0]);
    }

    public <T> void configureValue(String key, T value) {
        this.valueMap.put(key, value);
    }

    public void configureEvaluationFields(String key, String variant, String reason, ErrorType errorType, String errorMessage) {
        this.evaluationConfigMap.put(key, new FlagEvaluationConfig(variant, reason, errorType, errorMessage));
    }

    private void logCall(String methodName, Object ... args) {
        StringBuilder logEntry = new StringBuilder(methodName + "(");
        for (Object arg : args) {
            logEntry.append(arg).append(", ");
        }
        if (args.length > 0) {
            logEntry.setLength(logEntry.length() - 2);
        }
        logEntry.append(")");
        this.callHistory.add(logEntry.toString());
        log.debug(logEntry.toString());
    }

    public List<String> getCallHistory() {
        return new ArrayList<String>(this.callHistory);
    }

    private static class MockClientDelegate
    extends Confidence.ClientDelegate {
        private MockClientDelegate() {
            super(null, null, null, "");
        }

        @Override
        public void emit(String name, ConfidenceValue.Struct context, Optional<ConfidenceValue.Struct> message) {
        }

        @Override
        public void flush() {
        }

        @Override
        public CompletableFuture<ResolveFlagsResponse> resolveFlags(String flag, ConfidenceValue.Struct context) {
            return CompletableFuture.completedFuture(ResolveFlagsResponse.getDefaultInstance());
        }

        @Override
        public void close() {
        }
    }

    private static class FlagEvaluationConfig {
        String variant;
        String reason;
        ErrorType errorType;
        String errorMessage;

        FlagEvaluationConfig(String variant, String reason, ErrorType errorType, String errorMessage) {
            this.variant = variant;
            this.reason = reason;
            this.errorType = errorType;
            this.errorMessage = errorMessage;
        }
    }
}

