/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.ErrorType;
import com.spotify.confidence.Exceptions;
import com.spotify.confidence.FlagEvaluation;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfidenceUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfidenceUtils.class);

    private ConfidenceUtils() {
    }

    static ConfidenceValue getValueForPath(List<String> path, ConfidenceValue fullValue) throws Exceptions.ValueNotFound {
        ConfidenceValue value = fullValue;
        for (String fieldName : path) {
            ConfidenceValue.Struct structure = value.asStruct();
            if (structure == null) {
                log.warn("Illegal attempt to derive field '{}' on non-structure value '{}'", (Object)fieldName, (Object)value);
                throw new Exceptions.ValueNotFound(String.format("Illegal attempt to derive field '%s' on non-structure value '%s'", fieldName, value));
            }
            value = structure.get(fieldName);
            if (value != null) continue;
            log.warn("Illegal attempt to derive non-existing field '{}' on structure value '{}'", (Object)fieldName, (Object)structure);
            throw new Exceptions.ValueNotFound(String.format("Illegal attempt to derive non-existing field '%s' on structure value '%s'", fieldName, structure));
        }
        return value;
    }

    public static <T> Function<Throwable, ? extends FlagEvaluation<T>> handleFlagEvaluationError(T defaultValue) {
        return e -> {
            if (e instanceof CompletionException) {
                e = e.getCause();
            }
            log.warn(e.getMessage());
            if (e instanceof Exceptions.IllegalValuePath || e instanceof Exceptions.ValueNotFound) {
                return new FlagEvaluation<Object>(defaultValue, "", "ERROR", ErrorType.INVALID_VALUE_PATH, e.getMessage());
            }
            if (e instanceof Exceptions.IncompatibleValueType || e instanceof Exceptions.IllegalValueType) {
                return new FlagEvaluation<Object>(defaultValue, "", "ERROR", ErrorType.INVALID_VALUE_TYPE, e.getMessage());
            }
            if (e instanceof StatusRuntimeException || e.getCause() instanceof StatusRuntimeException) {
                return new FlagEvaluation<Object>(defaultValue, "", "ERROR", ErrorType.NETWORK_ERROR, e.getMessage());
            }
            return new FlagEvaluation<Object>(defaultValue, "", "ERROR", ErrorType.INTERNAL_ERROR, e.getMessage());
        };
    }

    static String getSdkVersion() {
        return "0.2.1";
    }
}

