/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.common.collect.ImmutableSet;
import com.spotify.confidence.Clock;
import com.spotify.confidence.ConfidenceUtils;
import com.spotify.confidence.EventUploader;
import com.spotify.confidence.GrpcUtil;
import com.spotify.confidence.events.v1.Event;
import com.spotify.confidence.events.v1.EventsServiceGrpc;
import com.spotify.confidence.events.v1.PublishEventsRequest;
import com.spotify.confidence.events.v1.Sdk;
import com.spotify.confidence.events.v1.SdkId;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcEventUploader
implements EventUploader {
    private final Set<Status.Code> RETRYABLE_STATUS_CODES = ImmutableSet.of((Object)Status.Code.UNKNOWN, (Object)Status.Code.DEADLINE_EXCEEDED, (Object)Status.Code.RESOURCE_EXHAUSTED, (Object)Status.Code.UNAVAILABLE, (Object)Status.Code.ABORTED, (Object)Status.Code.INTERNAL, (Object[])new Status.Code[]{Status.Code.DATA_LOSS});
    private final String clientSecret;
    private final Sdk sdk;
    private final ManagedChannel managedChannel;
    private final EventsServiceGrpc.EventsServiceFutureStub stub;
    private final Clock clock;
    private final int deadlineMillis;
    private static final Logger log = LoggerFactory.getLogger(GrpcEventUploader.class);

    GrpcEventUploader(String clientSecret, Clock clock, ManagedChannel managedChannel, int deadlineMillis) {
        this.clientSecret = clientSecret;
        this.managedChannel = managedChannel;
        this.stub = EventsServiceGrpc.newFutureStub((Channel)managedChannel);
        this.clock = clock;
        this.deadlineMillis = deadlineMillis;
        this.sdk = Sdk.newBuilder().setId(SdkId.SDK_ID_JAVA_CONFIDENCE).setVersion(ConfidenceUtils.getSdkVersion()).build();
    }

    @Override
    public CompletableFuture<Boolean> upload(List<Event> events) {
        PublishEventsRequest request = PublishEventsRequest.newBuilder().setClientSecret(this.clientSecret).setSendTime(this.clock.getTimestamp()).setSdk(this.sdk).addAllEvents(events).build();
        return ((CompletableFuture)GrpcUtil.toCompletableFuture(((EventsServiceGrpc.EventsServiceFutureStub)this.stub.withDeadlineAfter((long)this.deadlineMillis, TimeUnit.MILLISECONDS)).publishEvents(request)).thenApply(publishEventsResponse -> {
            List eventsInRequest = request.getEventsList();
            if (publishEventsResponse.getErrorsCount() == 0) {
                log.debug(String.format("Successfully published %d events", eventsInRequest.size()));
            } else {
                log.error(String.format("Published batch with %d events, of which %d failed. Failed events are of type: %s", eventsInRequest.size(), publishEventsResponse.getErrorsCount(), publishEventsResponse.getErrorsList().stream().map(e -> ((Event)eventsInRequest.get(e.getIndex())).getEventDefinition()).collect(Collectors.toSet())));
            }
            return true;
        })).exceptionally(throwable -> {
            log.error(String.format("Publishing batch failed with reason: %s", throwable.getMessage()), throwable);
            return !this.RETRYABLE_STATUS_CODES.contains(Status.fromThrowable((Throwable)throwable).getCode());
        });
    }
}

