/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.spotify.confidence.Telemetry;
import com.spotify.telemetry.v1.Monitoring;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Base64;
import javax.annotation.Nullable;

public class TelemetryClientInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> HEADER_KEY = Metadata.Key.of((String)"X-CONFIDENCE-TELEMETRY", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @Nullable
    private final Telemetry telemetry;

    public TelemetryClientInterceptor(@Nullable Telemetry telemetry) {
        this.telemetry = telemetry;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (TelemetryClientInterceptor.this.telemetry != null) {
                    Monitoring telemetrySnapshot = TelemetryClientInterceptor.this.telemetry.getSnapshot();
                    String base64Telemetry = Base64.getEncoder().encodeToString(telemetrySnapshot.toByteArray());
                    headers.put(HEADER_KEY, (Object)base64Telemetry);
                }
                super.start(responseListener, headers);
            }
        };
    }
}

