/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.spotify.confidence.Confidence;
import com.spotify.confidence.ConfidenceTest;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.ErrorType;
import com.spotify.confidence.EventSenderEngine;
import com.spotify.confidence.FakeClock;
import com.spotify.confidence.FakeEventSenderEngine;
import com.spotify.confidence.FlagEvaluation;
import com.spotify.confidence.FlagResolverClient;
import com.spotify.confidence.ResolverClientTestUtils;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsResponse;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveReason;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolvedFlag;
import com.spotify.confidence.shaded.flags.types.v1.FlagSchema;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ConfidenceAsyncTest {
    private final FakeEventSenderEngine fakeEngine = new FakeEventSenderEngine(new FakeClock());
    private final ResolverClientTestUtils.FakeFlagResolverClient fakeFlagResolverClient = new ResolverClientTestUtils.FakeFlagResolverClient();
    private static Confidence confidence;

    ConfidenceAsyncTest() {
    }

    @BeforeEach
    void beforeEach() {
        confidence = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
    }

    @AfterEach
    void afterEach() {
    }

    @Test
    void getValueFuture_basic() throws Exception {
        Integer value = (Integer)confidence.getValueFuture("flag.prop-E", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)50, (Integer)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("flag.prop-E", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)50, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"flags/flag/variants/var-A", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"RESOLVE_REASON_MATCH", (Object)evaluation.getReason());
        Assertions.assertTrue((boolean)evaluation.getErrorType().isEmpty());
        Assertions.assertTrue((boolean)evaluation.getErrorMessage().isEmpty());
    }

    @Test
    void getValueFuture_fullStruct() throws Exception {
        ConfidenceValue.Struct value = (ConfidenceValue.Struct)confidence.getValueFuture("flag", (Object)ConfidenceValue.Struct.EMPTY).get(1L, TimeUnit.SECONDS);
        ConfidenceValue.Struct expected = ConfidenceValue.Struct.builder().set("prop-A", ConfidenceValue.of((boolean)false)).set("prop-B", (ConfidenceValue)ConfidenceValue.Struct.builder().set("prop-C", ConfidenceValue.of((String)"str-val")).set("prop-D", ConfidenceValue.of((double)5.3)).build()).set("prop-E", ConfidenceValue.of((int)50)).set("prop-F", (ConfidenceValue)ConfidenceValue.List.of(List.of(ConfidenceValue.of((String)"a"), ConfidenceValue.of((String)"b")))).set("prop-G", (ConfidenceValue)ConfidenceValue.Struct.builder().set("prop-H", ConfidenceValue.NULL_VALUE).set("prop-I", ConfidenceValue.NULL_VALUE).build()).build();
        Assertions.assertEquals((Object)expected, (Object)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("flag", (Object)ConfidenceValue.Struct.EMPTY).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expected, (Object)evaluation.getValue());
        Assertions.assertEquals((Object)"flags/flag/variants/var-A", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"RESOLVE_REASON_MATCH", (Object)evaluation.getReason());
        Assertions.assertTrue((boolean)evaluation.getErrorType().isEmpty());
        Assertions.assertTrue((boolean)evaluation.getErrorMessage().isEmpty());
    }

    @Test
    void getValueFuture_incompatibleType() throws Exception {
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("flag.prop-E", (Object)"test").get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"test", (Object)evaluation.getValue());
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INVALID_VALUE_TYPE, evaluation.getErrorType().get());
        Assertions.assertEquals((Object)"Default type class java.lang.String, but value of type class com.spotify.confidence.ConfidenceValue$Integer", evaluation.getErrorMessage().get());
    }

    @Test
    void getValueFuture_unsupportedType() throws Exception {
        Date dateObject = Date.from(Instant.ofEpochSecond(100L));
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("flag.prop-E", (Object)dateObject).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)dateObject, (Object)evaluation.getValue());
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INVALID_VALUE_TYPE, evaluation.getErrorType().get());
        Assertions.assertEquals((Object)"Illegal value type: class java.util.Date", evaluation.getErrorMessage().get());
    }

    @Test
    void getValueFuture_nullValue() throws Exception {
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("flag.prop-G.prop-H", (Object)"test").get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"test", (Object)evaluation.getValue());
        Assertions.assertEquals((Object)"flags/flag/variants/var-A", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"RESOLVE_REASON_MATCH", (Object)evaluation.getReason());
        Assertions.assertTrue((boolean)evaluation.getErrorType().isEmpty());
        Assertions.assertTrue((boolean)evaluation.getErrorMessage().isEmpty());
    }

    @Test
    void getValueFuture_unexpectedReturnedFlag() throws Exception {
        Integer value = (Integer)confidence.getValueFuture("wrong-flag.prop-E", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("wrong-flag.prop-E", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INTERNAL_ERROR, evaluation.getErrorType().get());
        Assertions.assertEquals((Object)"Unexpected flag 'flag' from remote", evaluation.getErrorMessage().get());
    }

    @Test
    void getValueFuture_invalidValuePath() throws Exception {
        Integer value = (Integer)confidence.getValueFuture("flag.prop-X", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("flag.prop-X", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INVALID_VALUE_PATH, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("Illegal attempt to derive non-existing field 'prop-X' on structure value"));
    }

    @Test
    void getValueFuture_malformedValuePath() throws Exception {
        Integer value = (Integer)confidence.getValueFuture("...", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("...", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INVALID_VALUE_PATH, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("Illegal path string '...'"));
    }

    @Test
    void getValueFuture_flagNotFound() throws Exception {
        this.fakeFlagResolverClient.response = ResolveFlagsResponse.newBuilder().getDefaultInstanceForType();
        Integer value = (Integer)confidence.getValueFuture("unknown-flag", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("unknown-flag", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.FLAG_NOT_FOUND, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("No active flag 'unknown-flag' was found"));
    }

    @Test
    void getValueFuture_noSegmentMatch() throws Exception {
        this.fakeFlagResolverClient.response = ResolveFlagsResponse.newBuilder().addResolvedFlags(ResolvedFlag.newBuilder().setFlag("flags/no-match-flag").setVariant("").setReason(ResolveReason.RESOLVE_REASON_NO_SEGMENT_MATCH).build()).build();
        Integer value = (Integer)confidence.getValueFuture("no-match-flag", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("no-match-flag", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"RESOLVE_REASON_NO_SEGMENT_MATCH", (Object)evaluation.getReason());
        Assertions.assertTrue((boolean)evaluation.getErrorType().isEmpty());
        Assertions.assertTrue((boolean)evaluation.getErrorMessage().isEmpty());
    }

    @Test
    void getValueFuture_flagWithErroneousSchema() throws Exception {
        this.fakeFlagResolverClient.response = ResolveFlagsResponse.newBuilder().addResolvedFlags(ResolvedFlag.newBuilder().setFlagSchema(FlagSchema.StructFlagSchema.newBuilder().putSchema("key", FlagSchema.newBuilder().setStringSchema(FlagSchema.StringFlagSchema.getDefaultInstance()).build())).setValue(Struct.newBuilder().putAllFields(Map.of("key", Value.newBuilder().setNumberValue(3.14).build())).build()).setFlag("flags/wrong-schema-flag").setVariant("testB").setReason(ResolveReason.RESOLVE_REASON_MATCH).build()).build();
        Integer value = (Integer)confidence.getValueFuture("wrong-schema-flag", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("wrong-schema-flag", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INTERNAL_ERROR, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("Mismatch between schema and value: number_value: 3.14\n is a Number, but it should be STRING_SCHEMA"));
    }

    @Test
    void getValueFuture_internalError() throws Exception {
        Confidence confidence = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)new ConfidenceTest.FailingFlagResolverClient(), (String)"clientKey");
        Integer value = (Integer)confidence.getValueFuture("no-match-flag", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = (FlagEvaluation)confidence.getEvaluationFuture("no-match-flag", (Object)20).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INTERNAL_ERROR, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("Crashing while performing network call"));
        CompletableFuture future = confidence.getEvaluationFuture("no-match-flag", (Object)20);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
    }
}

