/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.common.collect.ImmutableMap;
import com.spotify.confidence.Confidence;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.EventSenderEngine;
import com.spotify.confidence.Exceptions;
import com.spotify.confidence.FakeClock;
import com.spotify.confidence.FakeEventSenderEngine;
import com.spotify.confidence.FlagResolverClient;
import com.spotify.confidence.ResolverClientTestUtils;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfidenceContextTest {
    private final FakeEventSenderEngine fakeEngine = new FakeEventSenderEngine(new FakeClock());
    private final ResolverClientTestUtils.FakeFlagResolverClient fakeFlagResolverClient = new ResolverClientTestUtils.FakeFlagResolverClient();

    @Test
    public void testThrowInvalidContextInMessage() {
        Confidence root = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
        org.junit.jupiter.api.Assertions.assertThrows(Exceptions.InvalidContextInMessaageError.class, () -> root.track("hello", ConfidenceValue.of(Map.of("context", ConfidenceValue.NULL_VALUE))));
    }

    @Test
    public void getContextContainsParentContextValues() {
        Confidence root = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
        root.updateContextEntry("page", ConfidenceValue.of((String)"http://.."));
        Confidence confidence = root.withContext((Map)ImmutableMap.of((Object)"pants", (Object)ConfidenceValue.of((String)"yellow")));
        Assertions.assertThat((Object)confidence.getContext()).isEqualTo((Object)ConfidenceValue.Struct.of((Map)ImmutableMap.of((Object)"page", (Object)ConfidenceValue.of((String)"http://.."), (Object)"pants", (Object)ConfidenceValue.of((String)"yellow"))));
    }

    @Test
    public void setContextOverwritesContext() {
        Confidence root = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
        root.updateContextEntry("page", ConfidenceValue.of((String)"http://.."));
        Confidence confidence = root.withContext((Map)ImmutableMap.of((Object)"pants", (Object)ConfidenceValue.of((String)"yellow")));
        Assertions.assertThat((Object)confidence.getContext()).isEqualTo((Object)ConfidenceValue.Struct.of((Map)ImmutableMap.of((Object)"page", (Object)ConfidenceValue.of((String)"http://.."), (Object)"pants", (Object)ConfidenceValue.of((String)"yellow"))));
        confidence.setContext((Map)ImmutableMap.of((Object)"shirt", (Object)ConfidenceValue.of((String)"blue")));
        Assertions.assertThat((Object)confidence.getContext()).isEqualTo((Object)ConfidenceValue.Struct.of((Map)ImmutableMap.of((Object)"page", (Object)ConfidenceValue.of((String)"http://.."), (Object)"shirt", (Object)ConfidenceValue.of((String)"blue"))));
    }

    @Test
    public void parentContextFieldCanBeOverridden() {
        Confidence root = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
        root.updateContextEntry("pants-color", ConfidenceValue.of((String)"yellow"));
        Confidence confidence = root.withContext((Map)ImmutableMap.of((Object)"pants-color", (Object)ConfidenceValue.of((String)"blue")));
        Assertions.assertThat((Object)confidence.getContext()).isEqualTo((Object)ConfidenceValue.Struct.of((Map)ImmutableMap.of((Object)"pants-color", (Object)ConfidenceValue.of((String)"blue"))));
        Assertions.assertThat((Object)root.getContext()).isEqualTo((Object)ConfidenceValue.Struct.of((Map)ImmutableMap.of((Object)"pants-color", (Object)ConfidenceValue.of((String)"yellow"))));
    }

    @Test
    public void parentContextFieldCanBeOverriddenOrRemoved() {
        Confidence root = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
        root.updateContextEntry("pants-color", ConfidenceValue.of((String)"yellow"));
        Confidence confidence = root.withContext((Map)ImmutableMap.of((Object)"shirt-color", (Object)ConfidenceValue.of((String)"blue")));
        confidence.removeContextEntry("pants-color");
        Assertions.assertThat((int)confidence.getContext().asMap().size()).isEqualTo(1);
        Assertions.assertThat((Object)confidence.getContext()).isEqualTo((Object)ConfidenceValue.Struct.of((Map)ImmutableMap.of((Object)"shirt-color", (Object)ConfidenceValue.of((String)"blue"))));
    }

    @Test
    public void multiLevelContexts() {
        Confidence root = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
        int numberOfLevels = 9;
        Confidence last = root;
        for (int i = 0; i < 9; ++i) {
            last = last.withContext((Map)ImmutableMap.of((Object)"level", (Object)ConfidenceValue.of((int)i), (Object)("level_" + i), (Object)ConfidenceValue.of((String)("i=" + i))));
        }
        Assertions.assertThat((int)last.getContext().asMap().size()).isEqualTo(10);
        Assertions.assertThat((Map)last.getContext().asMap()).isEqualTo((Object)ImmutableMap.of((Object)"level", (Object)ConfidenceValue.of((int)8), (Object)"level_0", (Object)ConfidenceValue.of((String)"i=0"), (Object)"level_1", (Object)ConfidenceValue.of((String)"i=1"), (Object)"level_2", (Object)ConfidenceValue.of((String)"i=2"), (Object)"level_3", (Object)ConfidenceValue.of((String)"i=3"), (Object)"level_4", (Object)ConfidenceValue.of((String)"i=4"), (Object)"level_5", (Object)ConfidenceValue.of((String)"i=5"), (Object)"level_6", (Object)ConfidenceValue.of((String)"i=6"), (Object)"level_7", (Object)ConfidenceValue.of((String)"i=7"), (Object)"level_8", (Object)ConfidenceValue.of((String)"i=8")));
    }
}

