/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.protobuf.Value;
import com.google.protobuf.util.Structs;
import com.google.protobuf.util.Values;
import com.spotify.confidence.Confidence;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.ErrorType;
import com.spotify.confidence.EventSenderEngine;
import com.spotify.confidence.FakeClock;
import com.spotify.confidence.FakeEventSenderEngine;
import com.spotify.confidence.FlagEvaluation;
import com.spotify.confidence.FlagResolver;
import com.spotify.confidence.FlagResolverClient;
import com.spotify.confidence.FlagResolverClientImpl;
import com.spotify.confidence.GrpcFlagResolver;
import com.spotify.confidence.ResolverClientTestUtils;
import com.spotify.confidence.Telemetry;
import com.spotify.confidence.TelemetryClientInterceptor;
import com.spotify.confidence.shaded.flags.resolver.v1.FlagResolverServiceGrpc;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsRequest;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsResponse;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolvedFlag;
import com.spotify.confidence.shaded.flags.types.v1.FlagSchema;
import com.spotify.confidence.telemetry.FakeTelemetryClientInterceptor;
import com.spotify.telemetry.v1.LibraryTraces;
import com.spotify.telemetry.v1.Monitoring;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

final class ConfidenceIntegrationTest {
    private static Server server;
    private static ManagedChannel channel;
    private static final FlagResolverServiceGrpc.FlagResolverServiceImplBase serviceImpl;
    private static final Map<String, ConfidenceValue> SAMPLE_CONTEXT_WITHOUT_TARGETING_KEY;
    private static final String DEFAULT_VALUE = "string-default";
    private static final Map<String, ConfidenceValue> SAMPLE_CONTEXT;
    static final String serverName;
    private Telemetry telemetry;
    private Confidence confidence;
    private FakeTelemetryClientInterceptor telemetryInterceptor;

    ConfidenceIntegrationTest() {
    }

    @BeforeAll
    static void before() throws IOException {
        server = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).addService((BindableService)serviceImpl)).build().start();
    }

    @BeforeEach
    void beforeEach() {
        FakeEventSenderEngine fakeEventSender = new FakeEventSenderEngine(new FakeClock());
        channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build();
        this.telemetry = new Telemetry();
        this.telemetryInterceptor = new FakeTelemetryClientInterceptor(this.telemetry);
        FlagResolverClientImpl flagResolver = new FlagResolverClientImpl((FlagResolver)new GrpcFlagResolver("fake-secret", channel, (TelemetryClientInterceptor)this.telemetryInterceptor, 1000), this.telemetry);
        this.confidence = Confidence.create((EventSenderEngine)fakeEventSender, (FlagResolverClient)flagResolver, (String)"");
    }

    @AfterAll
    static void after() {
        channel.shutdownNow();
        server.shutdownNow();
    }

    @Test
    public void nonExistingFlag() {
        this.mockResolve((request, streamObserver) -> {
            streamObserver.onNext((Object)ResolveFlagsResponse.getDefaultInstance());
            streamObserver.onCompleted();
        });
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("not-existing", (Object)DEFAULT_VALUE);
        Assertions.assertThat((String)((String)evaluationDetails.getValue())).isEqualTo(DEFAULT_VALUE);
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails.getErrorType().get())).isEqualTo((Object)ErrorType.FLAG_NOT_FOUND);
        Assertions.assertThat((String)evaluationDetails.getReason()).isEqualTo("ERROR");
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEmpty();
        Assertions.assertThat((String)((String)evaluationDetails.getErrorMessage().get())).isEqualTo("No active flag 'not-existing' was found");
    }

    @Test
    public void unexpectedFlag() {
        this.mockResolve((request, streamObserver) -> {
            streamObserver.onNext((Object)ResolveFlagsResponse.newBuilder().addResolvedFlags(ResolvedFlag.newBuilder().setFlag("flags/unexpected-flag").build()).build());
            streamObserver.onCompleted();
        });
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag", (Object)DEFAULT_VALUE);
        Assertions.assertThat((String)((String)evaluationDetails.getValue())).isEqualTo(DEFAULT_VALUE);
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails.getErrorType().get())).isEqualTo((Object)ErrorType.INTERNAL_ERROR);
        Assertions.assertThat((String)evaluationDetails.getReason()).isEqualTo("ERROR");
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEmpty();
        Assertions.assertThat((String)((String)evaluationDetails.getErrorMessage().get())).isEqualTo("Unexpected flag 'unexpected-flag' from remote");
    }

    @Test
    public void unavailableApi() {
        this.mockResolve((request, streamObserver) -> streamObserver.onError((Throwable)Status.UNAVAILABLE.asException()));
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flags/whatever", (Object)DEFAULT_VALUE);
        Assertions.assertThat((String)((String)evaluationDetails.getValue())).isEqualTo(DEFAULT_VALUE);
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails.getErrorType().get())).isEqualTo((Object)ErrorType.NETWORK_ERROR);
        Assertions.assertThat((String)evaluationDetails.getReason()).isEqualTo("ERROR");
        Assertions.assertThat((String)((String)evaluationDetails.getErrorMessage().get())).isEqualTo("UNAVAILABLE");
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEmpty();
    }

    @Test
    public void unauthenticated() {
        this.mockResolve((request, streamObserver) -> streamObserver.onError((Throwable)Status.UNAUTHENTICATED.asException()));
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flags/whatever", (Object)DEFAULT_VALUE);
        Assertions.assertThat((String)((String)evaluationDetails.getValue())).isEqualTo(DEFAULT_VALUE);
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails.getErrorType().get())).isEqualTo((Object)ErrorType.NETWORK_ERROR);
        Assertions.assertThat((String)evaluationDetails.getReason()).isEqualTo("ERROR");
        Assertions.assertThat((String)((String)evaluationDetails.getErrorMessage().get())).isEqualTo("UNAUTHENTICATED");
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEmpty();
    }

    @Test
    public void lackOfAssignment() {
        this.mockResolve((request, streamObserver) -> {
            streamObserver.onNext((Object)ResolveFlagsResponse.newBuilder().addResolvedFlags(ResolvedFlag.newBuilder().setFlag("flags/whatever").build()).build());
            streamObserver.onCompleted();
        });
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("whatever", (Object)DEFAULT_VALUE);
        Assertions.assertThat((String)((String)evaluationDetails.getValue())).isEqualTo(DEFAULT_VALUE);
        Assertions.assertThat((Optional)evaluationDetails.getErrorType()).isEmpty();
        Assertions.assertThat((Optional)evaluationDetails.getErrorMessage()).isEmpty();
        Assertions.assertThat((String)evaluationDetails.getReason()).startsWith((CharSequence)"RESOLVE_REASON_UNSPECIFIED");
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEmpty();
    }

    @Test
    public void regularResolve() {
        this.mockResolve((ResolveFlagsRequest2, streamObserver) -> {
            Assertions.assertThat((String)ResolveFlagsRequest2.getFlags(0)).isEqualTo("flags/flag");
            Assertions.assertThat((Object)ResolveFlagsRequest2.getEvaluationContext()).isEqualTo((Object)Structs.of((String)"my-targeting-key", (Value)Values.of((String)"the-target-id"), (String)"my-key", (Value)Values.of((boolean)true)));
            streamObserver.onNext((Object)ResolverClientTestUtils.generateSampleResponse(Collections.emptyList()));
            streamObserver.onCompleted();
        });
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag", (Object)ConfidenceValue.Struct.EMPTY);
        Assertions.assertThat((Optional)evaluationDetails.getErrorType()).isEmpty();
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails.getErrorMessage()).isEmpty();
        Assertions.assertThat((Object)((ConfidenceValue.Struct)evaluationDetails.getValue())).isEqualTo((Object)ConfidenceValue.of(Map.of("prop-A", ConfidenceValue.of((boolean)false), "prop-B", ConfidenceValue.of(Map.of("prop-C", ConfidenceValue.of((String)"str-val"), "prop-D", ConfidenceValue.of((double)5.3))), "prop-E", ConfidenceValue.of((int)50), "prop-F", ConfidenceValue.of(List.of(ConfidenceValue.of((String)"a"), ConfidenceValue.of((String)"b"))), "prop-G", ConfidenceValue.of(Map.of("prop-H", ConfidenceValue.NULL_VALUE, "prop-I", ConfidenceValue.NULL_VALUE)))));
    }

    @Test
    public void regularResolveWithoutTargetingKey() {
        this.mockResolve((ResolveFlagsRequest2, streamObserver) -> {
            Assertions.assertThat((String)ResolveFlagsRequest2.getFlags(0)).isEqualTo("flags/flag");
            Assertions.assertThat((Object)ResolveFlagsRequest2.getEvaluationContext()).isEqualTo((Object)Structs.of((String)"my-key", (Value)Values.of((boolean)true)));
            streamObserver.onNext((Object)ResolverClientTestUtils.generateSampleResponse(Collections.emptyList()));
            streamObserver.onCompleted();
        });
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT_WITHOUT_TARGETING_KEY).getEvaluation("flag", (Object)ConfidenceValue.Struct.EMPTY);
        Assertions.assertThat((Optional)evaluationDetails.getErrorType()).isEmpty();
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails.getErrorMessage()).isEmpty();
        Assertions.assertThat((Object)((ConfidenceValue)evaluationDetails.getValue())).isEqualTo((Object)ConfidenceValue.of(Map.of("prop-A", ConfidenceValue.of((boolean)false), "prop-B", ConfidenceValue.of(Map.of("prop-C", ConfidenceValue.of((String)"str-val"), "prop-D", ConfidenceValue.of((double)5.3))), "prop-E", ConfidenceValue.of((int)50), "prop-F", ConfidenceValue.of(List.of(ConfidenceValue.of((String)"a"), ConfidenceValue.of((String)"b"))), "prop-G", ConfidenceValue.of(Map.of("prop-H", ConfidenceValue.NULL_VALUE, "prop-I", ConfidenceValue.NULL_VALUE)))));
    }

    @Test
    public void regularResolveWithPath() {
        this.mockSampleResponse();
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-A", (Object)false);
        Assertions.assertThat((Optional)evaluationDetails.getErrorType()).isEmpty();
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails.getErrorMessage()).isEmpty();
        Assertions.assertThat((boolean)((Boolean)evaluationDetails.getValue())).isEqualTo(false);
        FlagEvaluation evaluationDetails2 = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-B", (Object)ConfidenceValue.Struct.EMPTY);
        Assertions.assertThat((Optional)evaluationDetails2.getErrorType()).isEmpty();
        Assertions.assertThat((String)evaluationDetails2.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails2.getErrorMessage()).isEmpty();
        Assertions.assertThat((Object)((ConfidenceValue.Struct)evaluationDetails2.getValue())).isEqualTo((Object)ConfidenceValue.of(Map.of("prop-C", ConfidenceValue.of((String)"str-val"), "prop-D", ConfidenceValue.of((double)5.3))));
        FlagEvaluation evaluationDetails3 = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-B.prop-C", (Object)DEFAULT_VALUE);
        Assertions.assertThat((Optional)evaluationDetails3.getErrorType()).isEmpty();
        Assertions.assertThat((String)evaluationDetails3.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails3.getErrorMessage()).isEmpty();
        Assertions.assertThat((String)((String)evaluationDetails3.getValue())).isEqualTo("str-val");
        FlagEvaluation evaluationDetails4 = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-G.prop-H", (Object)DEFAULT_VALUE);
        Assertions.assertThat((Optional)evaluationDetails4.getErrorType()).isEmpty();
        Assertions.assertThat((String)evaluationDetails4.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails4.getErrorMessage()).isEmpty();
        Assertions.assertThat((String)((String)evaluationDetails4.getValue())).isEqualTo(DEFAULT_VALUE);
        FlagEvaluation evaluationDetails5 = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-A.not-exist", (Object)DEFAULT_VALUE);
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails5.getErrorType().get())).isEqualTo((Object)ErrorType.INTERNAL_ERROR);
        Assertions.assertThat((String)evaluationDetails5.getVariant()).isEmpty();
        Assertions.assertThat((String)evaluationDetails5.getReason()).isEqualTo("ERROR");
        Assertions.assertThat((String)((String)evaluationDetails5.getErrorMessage().get())).isEqualTo("Not a StructValue");
        Assertions.assertThat((String)((String)evaluationDetails5.getValue())).isEqualTo(DEFAULT_VALUE);
        FlagEvaluation evaluationDetails6 = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.not-exist", (Object)DEFAULT_VALUE);
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails6.getErrorType().get())).isEqualTo((Object)ErrorType.INVALID_VALUE_PATH);
        Assertions.assertThat((String)evaluationDetails6.getVariant()).isEmpty();
        Assertions.assertThat((String)evaluationDetails6.getReason()).isEqualTo("ERROR");
        Assertions.assertThat((String)((String)evaluationDetails6.getErrorMessage().get())).isEqualTo("Illegal attempt to derive non-existing field 'not-exist' on structure value '{prop-B={prop-C=str-val, prop-D=5.3}, prop-E=50, prop-G={prop-I=NULL, prop-H=NULL}, prop-F=[[a, b]], prop-A=false}'");
        Assertions.assertThat((String)((String)evaluationDetails6.getValue())).isEqualTo(DEFAULT_VALUE);
        FlagEvaluation evaluationDetails7 = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("...", (Object)DEFAULT_VALUE);
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails7.getErrorType().get())).isEqualTo((Object)ErrorType.INVALID_VALUE_PATH);
        Assertions.assertThat((String)evaluationDetails7.getVariant()).isEmpty();
        Assertions.assertThat((String)evaluationDetails7.getReason()).isEqualTo("ERROR");
        Assertions.assertThat((String)((String)evaluationDetails7.getErrorMessage().get())).isEqualTo("Illegal path string '...'");
        Assertions.assertThat((String)((String)evaluationDetails7.getValue())).isEqualTo(DEFAULT_VALUE);
    }

    @Test
    public void booleanResolve() {
        this.mockSampleResponse();
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-A", (Object)true);
        Assertions.assertThat((Boolean)((Boolean)evaluationDetails.getValue())).isFalse();
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails.getErrorMessage()).isEmpty();
        Assertions.assertThat((Optional)evaluationDetails.getErrorType()).isEmpty();
    }

    @Test
    public void stringResolve() {
        this.mockSampleResponse();
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-B.prop-C", (Object)"default");
        Assertions.assertThat((String)((String)evaluationDetails.getValue())).isEqualTo("str-val");
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails.getErrorMessage()).isEmpty();
        Assertions.assertThat((Optional)evaluationDetails.getErrorType()).isEmpty();
    }

    @Test
    public void integerResolve() {
        this.mockSampleResponse();
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-E", (Object)1000);
        Assertions.assertThat((Integer)((Integer)evaluationDetails.getValue())).isEqualTo(50);
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails.getErrorMessage()).isEmpty();
        Assertions.assertThat((Optional)evaluationDetails.getErrorType()).isEmpty();
    }

    @Test
    public void doubleResolve() {
        this.mockSampleResponse();
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-B.prop-D", (Object)10.5);
        Assertions.assertThat((Double)((Double)evaluationDetails.getValue())).isEqualTo(5.3);
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEqualTo("flags/flag/variants/var-A");
        Assertions.assertThat((Optional)evaluationDetails.getErrorMessage()).isEmpty();
        Assertions.assertThat((Optional)evaluationDetails.getErrorType()).isEmpty();
    }

    @Test
    public void longValueInIntegerSchemaResolveShouldFail() {
        this.mockSampleResponse(Collections.singletonList(new ResolverClientTestUtils.ValueSchemaHolder("prop-X", Values.of((double)2.147483648E9), FlagSchema.SchemaTypeCase.INT_SCHEMA)));
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-X", (Object)10);
        Assertions.assertThat((Integer)((Integer)evaluationDetails.getValue())).isEqualTo(10);
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEmpty();
        Assertions.assertThat((String)((String)evaluationDetails.getErrorMessage().get())).isEqualTo("Mismatch between schema and value: 2.147483648E9 should be an int, but it is a double/long");
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails.getErrorType().get())).isEqualTo((Object)ErrorType.INTERNAL_ERROR);
    }

    @Test
    public void castingWithWrongType() {
        this.mockSampleResponse();
        FlagEvaluation evaluationDetails = this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-B.prop-C", (Object)true);
        Assertions.assertThat((Boolean)((Boolean)evaluationDetails.getValue())).isTrue();
        Assertions.assertThat((String)evaluationDetails.getVariant()).isEmpty();
        Assertions.assertThat((String)((String)evaluationDetails.getErrorMessage().get())).isEqualTo("Default type class java.lang.Boolean, but value of type class com.spotify.confidence.ConfidenceValue$StringValue");
        Assertions.assertThat((Comparable)((ErrorType)evaluationDetails.getErrorType().get())).isEqualTo((Object)ErrorType.INVALID_VALUE_TYPE);
    }

    @Test
    public void resolvesContainHeaderWithTelemetryData() {
        this.mockSampleResponse();
        this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-E", (Object)1000);
        Monitoring telemetrySnapshot = this.telemetry.getSnapshotInternal();
        List libraryTracesList = telemetrySnapshot.getLibraryTracesList();
        Assertions.assertThat((List)libraryTracesList).hasSize(1);
        LibraryTraces traces = (LibraryTraces)libraryTracesList.get(0);
        Assertions.assertThat((Comparable)traces.getLibrary()).isEqualTo((Object)LibraryTraces.Library.LIBRARY_CONFIDENCE);
        Assertions.assertThat((List)traces.getTracesList()).hasSize(1);
        LibraryTraces.Trace trace = traces.getTraces(0);
        Assertions.assertThat((Comparable)trace.getId()).isEqualTo((Object)LibraryTraces.TraceId.TRACE_ID_RESOLVE_LATENCY);
        Assertions.assertThat((long)trace.getMillisecondDuration()).isNotNegative();
        this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-Y", (Object)1000);
        Metadata storedHeaders = this.telemetryInterceptor.getStoredHeaders();
        Assertions.assertThat((boolean)storedHeaders.containsKey(TelemetryClientInterceptor.HEADER_KEY)).isTrue();
    }

    @Test
    public void resolveDoesNotContainHeaderWithTelemetryDataWhenDisabled() {
        FakeEventSenderEngine fakeEventSender = new FakeEventSenderEngine(new FakeClock());
        channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build();
        FakeTelemetryClientInterceptor nullTelemetryInterceptor = new FakeTelemetryClientInterceptor(null);
        FlagResolverClientImpl flagResolver = new FlagResolverClientImpl((FlagResolver)new GrpcFlagResolver("fake-secret", channel, (TelemetryClientInterceptor)nullTelemetryInterceptor, 1000));
        this.confidence = Confidence.create((EventSenderEngine)fakeEventSender, (FlagResolverClient)flagResolver, (String)"clientKey");
        this.mockSampleResponse();
        this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-E", (Object)1000);
        this.confidence.withContext(SAMPLE_CONTEXT).getEvaluation("flag.prop-E", (Object)1000);
        Metadata storedHeaders = nullTelemetryInterceptor.getStoredHeaders();
        Assertions.assertThat((boolean)storedHeaders.containsKey(TelemetryClientInterceptor.HEADER_KEY)).isFalse();
    }

    private void mockResolve(BiConsumer<ResolveFlagsRequest, StreamObserver<ResolveFlagsResponse>> impl) {
        ((FlagResolverServiceGrpc.FlagResolverServiceImplBase)Mockito.doAnswer(invocation -> {
            ResolveFlagsRequest ResolveFlagsRequest2 = (ResolveFlagsRequest)invocation.getArgument(0);
            StreamObserver streamObserver = (StreamObserver)invocation.getArgument(1);
            impl.accept(ResolveFlagsRequest2, streamObserver);
            return null;
        }).when((Object)serviceImpl)).resolveFlags((ResolveFlagsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
    }

    private void mockSampleResponse() {
        this.mockSampleResponse(Collections.emptyList());
    }

    private void mockSampleResponse(List<ResolverClientTestUtils.ValueSchemaHolder> additionalProps) {
        this.mockResolve((resolveFlagRequest, streamObserver) -> {
            Assertions.assertThat((String)resolveFlagRequest.getFlags(0)).isEqualTo("flags/flag");
            streamObserver.onNext((Object)ResolverClientTestUtils.generateSampleResponse(additionalProps));
            streamObserver.onCompleted();
        });
    }

    static {
        serviceImpl = (FlagResolverServiceGrpc.FlagResolverServiceImplBase)Mockito.mock(FlagResolverServiceGrpc.FlagResolverServiceImplBase.class);
        SAMPLE_CONTEXT_WITHOUT_TARGETING_KEY = Map.of("my-key", ConfidenceValue.of((boolean)true));
        SAMPLE_CONTEXT = Map.of("my-targeting-key", ConfidenceValue.of((String)"the-target-id"), "my-key", ConfidenceValue.of((boolean)true));
        serverName = InProcessServerBuilder.generateName();
    }
}

