/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.spotify.confidence.Confidence;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.EventSenderEngine;
import com.spotify.confidence.FakeClock;
import com.spotify.confidence.FakeEventSenderEngine;
import com.spotify.confidence.FlagResolverClient;
import com.spotify.confidence.ResolverClientTestUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfidenceResourceManagementTest {
    private Confidence root;
    private FakeEventSenderEngine fakeEngine;
    private ResolverClientTestUtils.FakeFlagResolverClient fakeFlagResolverClient;

    @BeforeEach
    public void setup() {
        this.fakeEngine = new FakeEventSenderEngine(new FakeClock());
        this.fakeFlagResolverClient = new ResolverClientTestUtils.FakeFlagResolverClient();
        this.root = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
    }

    @Test
    public void testCloseChildShouldThrowFromResolveFlags() throws IOException {
        Confidence child = this.root.withContext(Map.of("child-key", ConfidenceValue.of((String)"child")));
        child.close();
        Assertions.assertThrows(IllegalStateException.class, () -> child.resolveFlags("test").get());
    }

    @Test
    public void testCloseChildShouldNotCloseParentEngine() throws IOException {
        Confidence child = this.root.withContext(Map.of("child-key", ConfidenceValue.of((String)"child")));
        child.close();
        Assertions.assertFalse((boolean)this.fakeEngine.closed);
        Assertions.assertFalse((boolean)this.fakeFlagResolverClient.closed);
    }

    @Test
    public void testCloseChildShouldNotThrowFromSend() throws IOException {
        Confidence child = this.root.withContext(Map.of("child-key", ConfidenceValue.of((String)"child")));
        child.close();
        child.track("Test");
    }

    @Test
    public void testCloseChildShouldNotAffectParent() throws IOException, ExecutionException, InterruptedException {
        Confidence child = this.root.withContext(Map.of("child-key", ConfidenceValue.of((String)"child")));
        child.close();
        this.root.resolveFlags("test").get();
        this.root.track("test", ConfidenceValue.of(Map.of("messageKey", ConfidenceValue.of((String)"parent"))));
    }

    @Test
    public void testCloseParentShouldAffectChild() throws IOException {
        Confidence child = this.root.withContext(Map.of("child-key", ConfidenceValue.of((String)"child")));
        this.root.close();
        Assertions.assertThrows(IllegalStateException.class, () -> child.resolveFlags("test").get());
        Assertions.assertThrows(IllegalStateException.class, () -> this.root.resolveFlags("test").get());
        Assertions.assertTrue((boolean)this.fakeEngine.closed);
        Assertions.assertTrue((boolean)this.fakeFlagResolverClient.closed);
    }
}

