/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.spotify.confidence.Confidence;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.ErrorType;
import com.spotify.confidence.EventSenderEngine;
import com.spotify.confidence.FakeClock;
import com.spotify.confidence.FakeEventSenderEngine;
import com.spotify.confidence.FlagEvaluation;
import com.spotify.confidence.FlagResolverClient;
import com.spotify.confidence.ResolverClientTestUtils;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveFlagsResponse;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolveReason;
import com.spotify.confidence.shaded.flags.resolver.v1.ResolvedFlag;
import com.spotify.confidence.shaded.flags.types.v1.FlagSchema;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

final class ConfidenceTest {
    private final FakeEventSenderEngine fakeEngine = new FakeEventSenderEngine(new FakeClock());
    private final ResolverClientTestUtils.FakeFlagResolverClient fakeFlagResolverClient = new ResolverClientTestUtils.FakeFlagResolverClient();
    private static Confidence confidence;
    private ListAppender<ILoggingEvent> listAppender;
    private Logger confidenceLogger;

    ConfidenceTest() {
    }

    @BeforeEach
    void beforeEach() {
        confidence = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)this.fakeFlagResolverClient, (String)"clientKey");
        this.confidenceLogger = (Logger)LoggerFactory.getLogger(Confidence.class);
        this.listAppender = new ListAppender();
        this.listAppender.start();
        this.confidenceLogger.addAppender(this.listAppender);
    }

    @AfterEach
    void afterEach() {
        this.confidenceLogger.detachAppender(this.listAppender);
    }

    @Test
    void getValue() {
        Integer value = (Integer)confidence.getValue("flag.prop-E", (Object)20);
        Assertions.assertEquals((int)50, (Integer)value);
        FlagEvaluation evaluation = confidence.getEvaluation("flag.prop-E", (Object)20);
        Assertions.assertEquals((int)50, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"flags/flag/variants/var-A", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"RESOLVE_REASON_MATCH", (Object)evaluation.getReason());
        Assertions.assertTrue((boolean)evaluation.getErrorType().isEmpty());
        Assertions.assertTrue((boolean)evaluation.getErrorMessage().isEmpty());
    }

    @Test
    void getFullValue() {
        ConfidenceValue.Struct value = (ConfidenceValue.Struct)confidence.getValue("flag", (Object)ConfidenceValue.Struct.EMPTY);
        ConfidenceValue.Struct expected = ConfidenceValue.Struct.builder().set("prop-A", ConfidenceValue.of((boolean)false)).set("prop-B", (ConfidenceValue)ConfidenceValue.Struct.builder().set("prop-C", ConfidenceValue.of((String)"str-val")).set("prop-D", ConfidenceValue.of((double)5.3)).build()).set("prop-E", ConfidenceValue.of((int)50)).set("prop-F", (ConfidenceValue)ConfidenceValue.List.of(List.of(ConfidenceValue.of((String)"a"), ConfidenceValue.of((String)"b")))).set("prop-G", (ConfidenceValue)ConfidenceValue.Struct.builder().set("prop-H", ConfidenceValue.NULL_VALUE).set("prop-I", ConfidenceValue.NULL_VALUE).build()).build();
        Assertions.assertEquals((Object)expected, (Object)value);
        FlagEvaluation evaluation = confidence.getEvaluation("flag", (Object)ConfidenceValue.Struct.EMPTY);
        Assertions.assertEquals((Object)expected, (Object)evaluation.getValue());
        Assertions.assertEquals((Object)"flags/flag/variants/var-A", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"RESOLVE_REASON_MATCH", (Object)evaluation.getReason());
        Assertions.assertTrue((boolean)evaluation.getErrorType().isEmpty());
        Assertions.assertTrue((boolean)evaluation.getErrorMessage().isEmpty());
    }

    @Test
    void getValueIncompatibleType() {
        FlagEvaluation evaluation = confidence.getEvaluation("flag.prop-E", (Object)"test");
        Assertions.assertEquals((Object)"test", (Object)evaluation.getValue());
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INVALID_VALUE_TYPE, evaluation.getErrorType().get());
        Assertions.assertEquals((Object)"Default type class java.lang.String, but value of type class com.spotify.confidence.ConfidenceValue$Integer", evaluation.getErrorMessage().get());
    }

    @Test
    void getValueUnsupportedType() {
        Date dateObject = Date.from(Instant.ofEpochSecond(100L));
        FlagEvaluation evaluation = confidence.getEvaluation("flag.prop-E", (Object)dateObject);
        Assertions.assertEquals((Object)dateObject, (Object)evaluation.getValue());
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INVALID_VALUE_TYPE, evaluation.getErrorType().get());
        Assertions.assertEquals((Object)"Illegal value type: class java.util.Date", evaluation.getErrorMessage().get());
    }

    @Test
    void getNullValue() {
        FlagEvaluation evaluation = confidence.getEvaluation("flag.prop-G.prop-H", (Object)"test");
        Assertions.assertEquals((Object)"test", (Object)evaluation.getValue());
        Assertions.assertEquals((Object)"flags/flag/variants/var-A", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"RESOLVE_REASON_MATCH", (Object)evaluation.getReason());
        Assertions.assertTrue((boolean)evaluation.getErrorType().isEmpty());
        Assertions.assertTrue((boolean)evaluation.getErrorMessage().isEmpty());
    }

    @Test
    void unexpectedReturnedFlag() {
        Integer value = (Integer)confidence.getValue("wrong-flag.prop-E", (Object)20);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = confidence.getEvaluation("wrong-flag.prop-E", (Object)20);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INTERNAL_ERROR, evaluation.getErrorType().get());
        Assertions.assertEquals((Object)"Unexpected flag 'flag' from remote", evaluation.getErrorMessage().get());
    }

    @Test
    void invalidValuePath() {
        Integer value = (Integer)confidence.getValue("flag.prop-X", (Object)20);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = confidence.getEvaluation("flag.prop-X", (Object)20);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INVALID_VALUE_PATH, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("Illegal attempt to derive non-existing field 'prop-X' on structure value"));
    }

    @Test
    void malformedValuePath() {
        Integer value = (Integer)confidence.getValue("...", (Object)20);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = confidence.getEvaluation("...", (Object)20);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INVALID_VALUE_PATH, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("Illegal path string '...'"));
    }

    @Test
    void flagNotFound() {
        this.fakeFlagResolverClient.response = ResolveFlagsResponse.newBuilder().getDefaultInstanceForType();
        Integer value = (Integer)confidence.getValue("unknown-flag", (Object)20);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = confidence.getEvaluation("unknown-flag", (Object)20);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.FLAG_NOT_FOUND, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("No active flag 'unknown-flag' was found"));
    }

    @Test
    void noSegmentMatch() {
        this.fakeFlagResolverClient.response = ResolveFlagsResponse.newBuilder().addResolvedFlags(ResolvedFlag.newBuilder().setFlag("flags/no-match-flag").setVariant("").setReason(ResolveReason.RESOLVE_REASON_NO_SEGMENT_MATCH).build()).build();
        Integer value = (Integer)confidence.getValue("no-match-flag", (Object)20);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = confidence.getEvaluation("no-match-flag", (Object)20);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"RESOLVE_REASON_NO_SEGMENT_MATCH", (Object)evaluation.getReason());
        Assertions.assertTrue((boolean)evaluation.getErrorType().isEmpty());
        Assertions.assertTrue((boolean)evaluation.getErrorMessage().isEmpty());
    }

    @Test
    void flagWithErroneousSchema() {
        this.fakeFlagResolverClient.response = ResolveFlagsResponse.newBuilder().addResolvedFlags(ResolvedFlag.newBuilder().setFlagSchema(FlagSchema.StructFlagSchema.newBuilder().putSchema("key", FlagSchema.newBuilder().setStringSchema(FlagSchema.StringFlagSchema.getDefaultInstance()).build())).setValue(Struct.newBuilder().putAllFields(Map.of("key", Value.newBuilder().setNumberValue(3.14).build())).build()).setFlag("flags/wrong-schema-flag").setVariant("testB").setReason(ResolveReason.RESOLVE_REASON_MATCH).build()).build();
        Integer value = (Integer)confidence.getValue("wrong-schema-flag", (Object)20);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = confidence.getEvaluation("wrong-schema-flag", (Object)20);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INTERNAL_ERROR, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("Mismatch between schema and value: number_value: 3.14\n is a Number, but it should be STRING_SCHEMA"));
    }

    @Test
    void internalError() {
        Confidence confidence = Confidence.create((EventSenderEngine)this.fakeEngine, (FlagResolverClient)new FailingFlagResolverClient(), (String)"clientKey");
        Integer value = (Integer)confidence.getValue("no-match-flag", (Object)20);
        Assertions.assertEquals((int)20, (Integer)value);
        FlagEvaluation evaluation = confidence.getEvaluation("no-match-flag", (Object)20);
        Assertions.assertEquals((int)20, (Integer)((Integer)evaluation.getValue()));
        Assertions.assertEquals((Object)"", (Object)evaluation.getVariant());
        Assertions.assertEquals((Object)"ERROR", (Object)evaluation.getReason());
        Assertions.assertEquals((Object)ErrorType.INTERNAL_ERROR, evaluation.getErrorType().get());
        Assertions.assertTrue((boolean)((String)evaluation.getErrorMessage().get()).startsWith("Crashing while performing network call"));
    }

    @Test
    void shouldLogResolverHint() {
        confidence.withContext(Map.of("my_context_value", ConfidenceValue.of((int)42))).logResolveTesterHint(ResolvedFlag.newBuilder().setFlag("FlagName").build());
        List loggingEvents = this.listAppender.list;
        Assertions.assertTrue((loggingEvents.size() > 0 ? 1 : 0) != 0, (String)"No log message was captured.");
        ILoggingEvent lastLogEvent = (ILoggingEvent)loggingEvents.get(loggingEvents.size() - 1);
        Assertions.assertEquals((Object)Level.DEBUG, (Object)lastLogEvent.getLevel());
        Assertions.assertEquals((Object)"Check your flag evaluation for 'FlagName' by copy pasting the payload to the Resolve tester 'ewogICJjbGllbnRLZXkiOiAiY2xpZW50S2V5IiwKICAiZmxhZyI6ICJGbGFnTmFtZSIsCiAgImNvbnRleHQiOiB7CiAgICAibXlfY29udGV4dF92YWx1ZSI6IDQyLjAKICB9Cn0='", (Object)lastLogEvent.getFormattedMessage());
    }

    public static class FailingFlagResolverClient
    implements FlagResolverClient {
        public CompletableFuture<ResolveFlagsResponse> resolveFlags(String flag, ConfidenceValue.Struct context) {
            throw new RuntimeException("Crashing while performing network call");
        }

        public void close() throws IOException {
        }
    }
}

