/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.spotify.confidence.ConfidenceValue;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ConfidenceValueTest {
    ConfidenceValueTest() {
    }

    @Test
    public void testNull() {
        ConfidenceValue value = ConfidenceValue.NULL_VALUE;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)value.isNull());
        Assertions.assertThat((boolean)value.isStruct()).isFalse();
        Assertions.assertThat((boolean)value.isBoolean()).isFalse();
        Assertions.assertThat((boolean)value.isString()).isFalse();
        Assertions.assertThat((boolean)value.isInteger()).isFalse();
        Assertions.assertThat((boolean)value.isDouble()).isFalse();
        Assertions.assertThat((boolean)value.isTimestamp()).isFalse();
        Assertions.assertThat((boolean)value.isDate()).isFalse();
        Assertions.assertThat((boolean)value.isList()).isFalse();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asStruct());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asString());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asInteger());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asDouble());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asInstant());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asLocalDate());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asList());
    }

    @Test
    public void testStringValue() {
        ConfidenceValue stringValue = ConfidenceValue.of((String)"test value");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stringValue.isString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test value", (Object)stringValue.asString());
    }

    @Test
    public void testBooleanValue() {
        ConfidenceValue booleanValue = ConfidenceValue.of((boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)booleanValue.isBoolean());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)booleanValue.asBoolean());
    }

    @Test
    public void testBooleanFromProto() {
        Value protoValue = Value.newBuilder().setBoolValue(true).build();
        ConfidenceValue booleanValue = ConfidenceValue.fromProto((Value)protoValue);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)booleanValue.isBoolean());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)booleanValue.asBoolean());
    }

    @Test
    public void testIntegerValue() {
        ConfidenceValue integerValue = ConfidenceValue.of((int)42);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)integerValue.isInteger());
        org.junit.jupiter.api.Assertions.assertEquals((int)42, (int)integerValue.asInteger());
    }

    @Test
    public void testDoubleValue() {
        ConfidenceValue doubleValue = ConfidenceValue.of((double)42.0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)doubleValue.isDouble());
        org.junit.jupiter.api.Assertions.assertEquals((double)42.0, (double)doubleValue.asDouble());
    }

    @Test
    public void testDoubleFromProto() {
        Value integerProtoValue = Value.newBuilder().setNumberValue(42.0).build();
        Value doubleProtoValue = Value.newBuilder().setNumberValue(42.0).build();
        ConfidenceValue value1 = ConfidenceValue.fromProto((Value)integerProtoValue);
        ConfidenceValue value2 = ConfidenceValue.fromProto((Value)doubleProtoValue);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)value1.isDouble());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)value2.isDouble());
        org.junit.jupiter.api.Assertions.assertEquals((double)42.0, (double)value1.asDouble());
        org.junit.jupiter.api.Assertions.assertEquals((double)42.0, (double)value2.asDouble());
    }

    @Test
    public void testTimestampValue() {
        Instant instant = Instant.parse("2007-12-03T10:15:30.00Z");
        ConfidenceValue timestampValue = ConfidenceValue.of((Instant)instant);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timestampValue.isTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instant, (Object)timestampValue.asInstant());
    }

    @Test
    public void testTimestampFromProto() {
        String isoString = "2007-12-03T10:15:30.00Z";
        Value timestampProtoValue = Value.newBuilder().setStringValue("2007-12-03T10:15:30.00Z").build();
        ConfidenceValue timestampValue = ConfidenceValue.fromProto((Value)timestampProtoValue);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timestampValue.isTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Instant.parse("2007-12-03T10:15:30.00Z"), (Object)timestampValue.asInstant());
    }

    @Test
    public void testDateValue() {
        LocalDate localDate = LocalDate.parse("2007-12-03");
        ConfidenceValue timestampValue = ConfidenceValue.of((LocalDate)localDate);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timestampValue.isDate());
        org.junit.jupiter.api.Assertions.assertEquals((Object)localDate, (Object)timestampValue.asLocalDate());
    }

    @Test
    public void testDateFromProto() {
        String isoString = "2007-12-03";
        Value dateProtoValue = Value.newBuilder().setStringValue("2007-12-03").build();
        ConfidenceValue dateValue = ConfidenceValue.fromProto((Value)dateProtoValue);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dateValue.isDate());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LocalDate.parse("2007-12-03"), (Object)dateValue.asLocalDate());
    }

    @Test
    public void testNullValue() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ConfidenceValue.NULL_VALUE.isNull());
    }

    @Test
    public void testStructValue() {
        HashMap<String, ConfidenceValue> map = new HashMap<String, ConfidenceValue>();
        map.put("key", ConfidenceValue.of((String)"value"));
        ConfidenceValue.Struct structValue = ConfidenceValue.of(map);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)structValue.isStruct());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)structValue.asStruct().get(new String[]{"key"}).asString());
    }

    @Test
    public void testStringListValue() {
        ConfidenceValue.List listValue = ConfidenceValue.ofStrings((List)ImmutableList.of((Object)"item1", (Object)"item2"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)listValue.isList());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableList.of((Object)ConfidenceValue.of((String)"item1"), (Object)ConfidenceValue.of((String)"item2")), (Object)listValue.asList());
        org.junit.jupiter.api.Assertions.assertEquals((Object)listValue.toProto(), (Object)Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)Stream.of(ConfidenceValue.of((String)"item1"), ConfidenceValue.of((String)"item2")).map(ConfidenceValue::toProto).collect(Collectors.toList()))).build());
    }

    @Test
    public void testIntegerListValue() {
        ConfidenceValue.List listValue = ConfidenceValue.ofIntegers((List)ImmutableList.of((Object)3, (Object)5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)listValue.toProto(), (Object)Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)Stream.of(ConfidenceValue.of((int)3), ConfidenceValue.of((int)5)).map(ConfidenceValue::toProto).collect(Collectors.toList()))).build());
    }

    @Test
    public void testDoubleListValue() {
        ConfidenceValue.List listValue = ConfidenceValue.ofDoubles((List)ImmutableList.of((Object)3.1, (Object)4.2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)listValue.toProto(), (Object)Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)Stream.of(ConfidenceValue.of((double)3.1), ConfidenceValue.of((double)4.2)).map(ConfidenceValue::toProto).collect(Collectors.toList()))).build());
    }

    @Test
    public void testTimestampListValue() {
        Instant instant1 = Instant.parse("2007-12-03T10:15:30.00Z");
        Instant instant2 = Instant.parse("2007-12-03T10:15:31.00Z");
        ConfidenceValue.List listValue = ConfidenceValue.ofTimestamps((List)ImmutableList.of((Object)instant1, (Object)instant2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)listValue.toProto(), (Object)Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)Stream.of(ConfidenceValue.of((Instant)instant1), ConfidenceValue.of((Instant)instant2)).map(ConfidenceValue::toProto).collect(Collectors.toList()))).build());
    }

    @Test
    public void testDateListValue() {
        LocalDate date1 = LocalDate.parse("2007-12-03");
        LocalDate date2 = LocalDate.parse("2007-12-04");
        ConfidenceValue.List listValue = ConfidenceValue.ofDates((List)ImmutableList.of((Object)date1, (Object)date2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)listValue.toProto(), (Object)Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)Stream.of(ConfidenceValue.of((LocalDate)date1), ConfidenceValue.of((LocalDate)date2)).map(ConfidenceValue::toProto).collect(Collectors.toList()))).build());
    }

    @Test
    public void testBooleanListValue() {
        ConfidenceValue.List listValue = ConfidenceValue.ofBooleans((List)ImmutableList.of((Object)true, (Object)false));
        org.junit.jupiter.api.Assertions.assertEquals((Object)listValue.toProto(), (Object)Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)Stream.of(ConfidenceValue.of((boolean)true), ConfidenceValue.of((boolean)false)).map(ConfidenceValue::toProto).collect(Collectors.toList()))).build());
    }

    @Test
    public void testStringFromProto() {
        ConfidenceValue fromProtoValue = ConfidenceValue.fromProto((Value)ConfidenceValue.of((String)"test value").toProto());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fromProtoValue.isString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test value", (Object)fromProtoValue.asString());
    }

    @Test
    public void testToProto() {
        ConfidenceValue value = ConfidenceValue.of((String)"test value");
        Value protoValue = value.toProto();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Value.KindCase.STRING_VALUE, (Object)protoValue.getKindCase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test value", (Object)protoValue.getStringValue());
    }

    @Test
    public void testStructAsProtoMap() {
        HashMap<String, ConfidenceValue> map = new HashMap<String, ConfidenceValue>();
        map.put("key", ConfidenceValue.of((String)"value"));
        ConfidenceValue.Struct structValue = ConfidenceValue.of(map);
        Map protoMap = structValue.asProtoMap();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)protoMap.containsKey("key"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)((Value)protoMap.get("key")).getStringValue());
    }

    @Test
    public void testStructToProto() {
        ConfidenceValue.Struct structValue = ConfidenceValue.Struct.builder().set("key", "value").build();
        Value proto = structValue.toProto();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Value.KindCase.STRUCT_VALUE, (Object)proto.getKindCase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)proto.getStructValue().getFieldsOrThrow("key").getStringValue());
    }

    @Test
    public void testListFromProto() {
        ListValue protoListValue = ListValue.newBuilder().addAllValues((Iterable)Stream.of(ConfidenceValue.of((String)"item1"), ConfidenceValue.of((String)"item2")).map(ConfidenceValue::toProto).collect(Collectors.toList())).build();
        ConfidenceValue.List listValue = ConfidenceValue.List.fromProto((ListValue)protoListValue);
        org.junit.jupiter.api.Assertions.assertEquals((Object)((ConfidenceValue)listValue.asList().get(0)).asString(), (Object)((Value)protoListValue.getValuesList().get(0)).getStringValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((ConfidenceValue)listValue.asList().get(1)).asString(), (Object)((Value)protoListValue.getValuesList().get(1)).getStringValue());
    }

    @Test
    public void testExceptions() {
        ConfidenceValue value = ConfidenceValue.of((String)"test value");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asInteger());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asDouble());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asInstant());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asLocalDate());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asBoolean());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asStruct());
    }

    @Test
    public void testStructEmpty() {
        ConfidenceValue.Struct value = ConfidenceValue.Struct.EMPTY;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)value.isStruct());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asInteger());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asDouble());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asLocalDate());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asString());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ConfidenceValue)value).asBoolean());
    }

    @Test
    public void testStructGet() {
        HashMap<String, ConfidenceValue> map = new HashMap<String, ConfidenceValue>();
        map.put("key", ConfidenceValue.of((String)"value"));
        ConfidenceValue.Struct struct = ConfidenceValue.of(map);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.of((String)"value"), (Object)struct.get(new String[]{"key"}));
        org.junit.jupiter.api.Assertions.assertNull((Object)struct.get(new String[]{"nonexistent"}));
    }

    @Test
    public void testStructToString() {
        Instant instant = Instant.parse("2007-12-03T10:15:30.00Z");
        LocalDate localDate = LocalDate.parse("2007-12-03");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("string", ConfidenceValue.of((String)"value"));
        map.put("integer", ConfidenceValue.of((int)42));
        map.put("double", ConfidenceValue.of((double)42.0));
        map.put("timestamp", ConfidenceValue.of((Instant)instant));
        map.put("date", ConfidenceValue.of((LocalDate)localDate));
        map.put("boolean", ConfidenceValue.of((boolean)false));
        map.put("list", ConfidenceValue.ofStrings(List.of("item1", "item2")));
        map.put("timestamp_list", ConfidenceValue.ofTimestamps(List.of(instant, instant)));
        map.put("struct", ConfidenceValue.of(map));
        ConfidenceValue.Struct struct = ConfidenceValue.of(map);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{date=2007-12-03, struct={date=2007-12-03, boolean=false, string=value, double=42.0, timestamp_list=[[2007-12-03T10:15:30Z, 2007-12-03T10:15:30Z]], integer=42, list=[[item1, item2]], timestamp=2007-12-03T10:15:30Z}, boolean=false, string=value, double=42.0, timestamp_list=[[2007-12-03T10:15:30Z, 2007-12-03T10:15:30Z]], integer=42, list=[[item1, item2]], timestamp=2007-12-03T10:15:30Z}", (Object)struct.toString());
    }

    @Test
    public void testStructFromProto() {
        Struct protoStruct = Struct.newBuilder().putFields("key", ConfidenceValue.of((String)"value").toProto()).build();
        ConfidenceValue.Struct struct = ConfidenceValue.Struct.fromProto((Struct)protoStruct);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.of((String)"value"), (Object)struct.get(new String[]{"key"}));
    }

    @Test
    public void testStructAsMap() {
        HashMap<String, ConfidenceValue> map = new HashMap<String, ConfidenceValue>();
        map.put("key", ConfidenceValue.of((String)"value"));
        ConfidenceValue.Struct struct = ConfidenceValue.of(map);
        org.junit.jupiter.api.Assertions.assertEquals(map, (Object)struct.asMap());
    }

    @Test
    public void testStructBuilderSetValues() {
        Instant instant = Instant.parse("2007-12-03T10:15:30.00Z");
        LocalDate date = LocalDate.parse("2007-12-03");
        List<String> stringList = List.of("string1", "string2");
        ConfidenceValue.Struct struct = ConfidenceValue.Struct.builder().set("key1", "value").set("key2", 42).set("key3", true).set("key4", 42.0).set("key5", instant).set("key6", date).setStrings("key7", (List)ImmutableList.of((Object)"string1", (Object)"string2")).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.of((String)"value"), (Object)struct.get(new String[]{"key1"}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.of((int)42), (Object)struct.get(new String[]{"key2"}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.of((boolean)true), (Object)struct.get(new String[]{"key3"}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.of((double)42.0), (Object)struct.get(new String[]{"key4"}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.of((Instant)instant), (Object)struct.get(new String[]{"key5"}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.of((LocalDate)date), (Object)struct.get(new String[]{"key6"}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConfidenceValue.ofStrings(stringList), (Object)struct.get(new String[]{"key7"}));
    }

    @Test
    public void testStructGetWithMultipleKeys() {
        ConfidenceValue.Struct.Builder builder = ConfidenceValue.Struct.builder();
        ConfidenceValue.Struct innerStruct = builder.set("innerKey", "innerValue").build();
        builder.set("key", (ConfidenceValue)innerStruct);
        ConfidenceValue.Struct structValue = builder.build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"innerValue", (Object)structValue.get(new String[]{"key", "innerKey"}).asString());
    }

    @Test
    public void testStructGetWithInvalidPath() {
        ConfidenceValue.Struct.Builder builder = ConfidenceValue.Struct.builder();
        builder.set("key", "value");
        ConfidenceValue.Struct structValue = builder.build();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> structValue.get(new String[]{"key", "invalid"}));
    }

    @Test
    public void testStructGetWithMissingKey() {
        ConfidenceValue.Struct.Builder builder = ConfidenceValue.Struct.builder();
        builder.set("key", "value");
        ConfidenceValue.Struct structValue = builder.build();
        org.junit.jupiter.api.Assertions.assertNull((Object)structValue.get(new String[]{"missingKey"}));
    }

    @Test
    public void testStructIsEmpty() {
        ConfidenceValue.Struct structValue = ConfidenceValue.Struct.EMPTY;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)structValue.asMap().isEmpty());
    }

    @Test
    public void testUnsupportedValueKind() {
        Value protoValue = Value.newBuilder().build();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ConfidenceValue.fromProto((Value)protoValue));
    }
}

