/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.spotify.confidence.EventUploader;
import com.spotify.confidence.events.v1.Event;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class FakeUploader
implements EventUploader {
    private final List<Integer> failAtUploadWithIndex;
    private final AtomicInteger uploadCount = new AtomicInteger();
    public Queue<List<Event>> uploadCalls = new ConcurrentLinkedQueue<List<Event>>();

    public FakeUploader() {
        this.failAtUploadWithIndex = List.of();
    }

    public FakeUploader(List<Integer> failAtUploadWithIndex) {
        this.failAtUploadWithIndex = failAtUploadWithIndex;
    }

    public CompletableFuture<Boolean> upload(List<Event> events) {
        this.uploadCalls.add(events);
        int uploadCount = this.uploadCount.incrementAndGet();
        if (this.failAtUploadWithIndex.contains(uploadCount)) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(true);
    }

    public void reset() {
        this.uploadCount.set(0);
        this.uploadCalls.clear();
    }
}

