/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.confidence;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import com.spotify.confidence.Clock;
import com.spotify.confidence.ConfidenceValue;
import com.spotify.confidence.EventUploader;
import com.spotify.confidence.FakeClock;
import com.spotify.confidence.GrpcEventUploader;
import com.spotify.confidence.events.v1.Event;
import com.spotify.confidence.events.v1.EventError;
import com.spotify.confidence.events.v1.EventsServiceGrpc;
import com.spotify.confidence.events.v1.PublishEventsRequest;
import com.spotify.confidence.events.v1.PublishEventsResponse;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class GrpcEventUploaderTest {
    private static final String CONTEXT = "context";
    private GrpcEventUploader uploader;
    private Server server;
    private ManagedChannel channel;
    private FakedEventsService fakedEventsService;
    private static FakeClock fakeClock = new FakeClock();

    GrpcEventUploaderTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        String serverName = InProcessServerBuilder.generateName();
        this.fakedEventsService = new FakedEventsService();
        this.server = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).addService((BindableService)this.fakedEventsService)).build().start();
        this.channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build();
        fakeClock.setCurrentTimeSeconds(1337L);
        this.uploader = new GrpcEventUploader("my-client-secret", (Clock)fakeClock, this.channel, 5000);
    }

    @AfterEach
    public void tearDown() {
        this.fakedEventsService.clear();
        this.channel.shutdown();
        this.server.shutdown();
    }

    @Test
    public void testSendTime() {
        this.uploader.upload(List.of(Event.newBuilder().setEventTime(Timestamp.newBuilder().setSeconds(1337L)).build()));
        Assertions.assertThat(this.fakedEventsService.requests).hasSize(1);
        PublishEventsRequest request = this.fakedEventsService.requests.get(0);
        Assertions.assertThat((long)request.getSendTime().getSeconds()).isEqualTo(1337L);
    }

    @Test
    public void testMapsSingleEventBatchToProtobuf() throws ExecutionException, InterruptedException {
        CompletableFuture completableFuture = this.uploader.upload(List.of(EventUploader.event((String)"event1", (ConfidenceValue.Struct)this.contextStruct("1"), Optional.of(this.messageStruct("1"))).setEventTime(Timestamp.newBuilder().setSeconds(1337L)).build()));
        Boolean result = (Boolean)completableFuture.get();
        Assertions.assertThat((Boolean)result).isTrue();
        Assertions.assertThat(this.fakedEventsService.requests).hasSize(1);
        PublishEventsRequest request = this.fakedEventsService.requests.get(0);
        Assertions.assertThat((List)request.getEventsList()).hasSize(1);
        Event protoEvent = request.getEvents(0);
        Assertions.assertThat((String)protoEvent.getEventDefinition()).isEqualTo("eventDefinitions/event1");
        Map fieldsMap = protoEvent.getPayload().getFieldsMap();
        Assertions.assertThat((String)((Value)fieldsMap.get("messageKey")).getStringValue()).isEqualTo("value_1");
        Assertions.assertThat((String)((Value)fieldsMap.get(CONTEXT)).getStructValue().getFieldsOrThrow("contextKey").getStringValue()).isEqualTo("value_1");
    }

    @Test
    public void testMapsMultiEventBatchToProtobuf() {
        List<Event> batch = List.of(EventUploader.event((String)"event1", (ConfidenceValue.Struct)this.contextStruct("c1"), Optional.of(this.messageStruct("m1"))).setEventTime(Timestamp.newBuilder().setSeconds(1337L)).build(), EventUploader.event((String)"event2", (ConfidenceValue.Struct)this.contextStruct("c2"), Optional.of(this.messageStruct("m2"))).setEventTime(Timestamp.newBuilder().setSeconds(1338L)).build(), EventUploader.event((String)"event3", (ConfidenceValue.Struct)this.contextStruct("c3"), Optional.of(this.messageStruct("m3"))).setEventTime(Timestamp.newBuilder().setSeconds(1339L)).build(), EventUploader.event((String)"event4", (ConfidenceValue.Struct)this.contextStruct("c4"), Optional.of(this.messageStruct("m4"))).setEventTime(Timestamp.newBuilder().setSeconds(1340L)).build());
        this.uploader.upload(batch);
        Assertions.assertThat(this.fakedEventsService.requests).hasSize(1);
        PublishEventsRequest request = this.fakedEventsService.requests.get(0);
        Assertions.assertThat((List)request.getEventsList()).hasSize(4);
        for (int i = 0; i < batch.size(); ++i) {
            Event protoEvent = request.getEvents(i);
            Assertions.assertThat((String)protoEvent.getEventDefinition()).isEqualTo("eventDefinitions/event" + (i + 1));
            Map fieldsMap = protoEvent.getPayload().getFieldsMap();
            Assertions.assertThat((String)((Value)fieldsMap.get("messageKey")).getStringValue()).isEqualTo("value_m" + (i + 1));
            Assertions.assertThat((String)((Value)fieldsMap.get(CONTEXT)).getStructValue().getFieldsOrThrow("contextKey").getStringValue()).isEqualTo("value_c" + (i + 1));
        }
    }

    @Test
    public void testMapsMultiEventBatchToProtobufSparseErrors() throws ExecutionException, InterruptedException {
        this.fakedEventsService.resultType = ResultType.FIRST_EVENT_ERROR;
        List<Event> batch = List.of(EventUploader.event((String)"event1", (ConfidenceValue.Struct)this.contextStruct("c1"), Optional.of(this.messageStruct("m1"))).setEventTime(Timestamp.newBuilder().setSeconds(1337L)).build(), EventUploader.event((String)"event2", (ConfidenceValue.Struct)this.contextStruct("c2"), Optional.of(this.messageStruct("m2"))).setEventTime(Timestamp.newBuilder().setSeconds(1338L)).build(), EventUploader.event((String)"event3", (ConfidenceValue.Struct)this.contextStruct("c3"), Optional.of(this.messageStruct("m3"))).setEventTime(Timestamp.newBuilder().setSeconds(1339L)).build(), EventUploader.event((String)"event4", (ConfidenceValue.Struct)this.contextStruct("c4"), Optional.of(this.messageStruct("m4"))).setEventTime(Timestamp.newBuilder().setSeconds(1340L)).build());
        CompletableFuture completableFuture = this.uploader.upload(batch);
        Assertions.assertThat(this.fakedEventsService.requests).hasSize(1);
        PublishEventsRequest request = this.fakedEventsService.requests.get(0);
        Assertions.assertThat((List)request.getEventsList()).hasSize(4);
        Boolean result = (Boolean)completableFuture.get();
        Assertions.assertThat((Boolean)result).isTrue();
    }

    @Test
    public void testServiceThrows() throws ExecutionException, InterruptedException {
        this.fakedEventsService.resultType = ResultType.REQUEST_ERROR;
        List<Event> batch = List.of(EventUploader.event((String)"event1", (ConfidenceValue.Struct)this.contextStruct("1"), Optional.of(this.messageStruct("1"))).setEventTime(Timestamp.newBuilder().setSeconds(1337L)).build());
        CompletableFuture completableFuture = this.uploader.upload(batch);
        Assertions.assertThat(this.fakedEventsService.requests).hasSize(1);
        Boolean result = (Boolean)completableFuture.get();
        Assertions.assertThat((Boolean)result).isFalse();
    }

    private ConfidenceValue.Struct contextStruct(String s) {
        return ConfidenceValue.of((Map)ImmutableMap.of((Object)"contextKey", (Object)ConfidenceValue.of((String)("value_" + s))));
    }

    private ConfidenceValue.Struct messageStruct(String s) {
        return ConfidenceValue.of((Map)ImmutableMap.of((Object)"messageKey", (Object)ConfidenceValue.of((String)("value_" + s))));
    }

    private static class FakedEventsService
    extends EventsServiceGrpc.EventsServiceImplBase {
        public ResultType resultType;
        final List<PublishEventsRequest> requests = new ArrayList<PublishEventsRequest>();

        private FakedEventsService() {
        }

        public void clear() {
            this.requests.clear();
            this.resultType = ResultType.SUCCESS;
        }

        public void publishEvents(PublishEventsRequest request, StreamObserver<PublishEventsResponse> responseObserver) {
            this.requests.add(request);
            if (this.resultType == ResultType.REQUEST_ERROR) {
                responseObserver.onError((Throwable)new RuntimeException("error"));
            } else if (this.resultType == ResultType.FIRST_EVENT_ERROR) {
                responseObserver.onNext((Object)PublishEventsResponse.newBuilder().addErrors(0, EventError.newBuilder().setReason(EventError.Reason.EVENT_SCHEMA_VALIDATION_FAILED).build()).build());
                responseObserver.onCompleted();
            } else {
                responseObserver.onNext((Object)PublishEventsResponse.newBuilder().build());
                responseObserver.onCompleted();
            }
        }
    }

    private static enum ResultType {
        REQUEST_ERROR,
        FIRST_EVENT_ERROR,
        SUCCESS;

    }
}

