/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.IssueCommentEvent;
import com.spotify.github.v3.comment.Comment;
import com.spotify.github.v3.issues.Issue;
import com.spotify.github.v3.issues.changes.Changes;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IssueCommentEvent", generator="Immutables")
@Immutable
public final class ImmutableIssueCommentEvent
implements IssueCommentEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String action;
    @Nullable
    private final Changes changes;
    @Nullable
    private final Issue issue;
    @Nullable
    private final Comment comment;

    private ImmutableIssueCommentEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String action, @Nullable Changes changes, @Nullable Issue issue, @Nullable Comment comment) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.action = action;
        this.changes = changes;
        this.issue = issue;
        this.comment = comment;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    public Optional<Changes> changes() {
        return Optional.ofNullable(this.changes);
    }

    @Override
    @JsonProperty
    @Nullable
    public Issue issue() {
        return this.issue;
    }

    @Override
    @JsonProperty
    @Nullable
    public Comment comment() {
        return this.comment;
    }

    public final ImmutableIssueCommentEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableIssueCommentEvent(value, this.sender, this.eventInstallation, this.action, this.changes, this.issue, this.comment);
    }

    public final ImmutableIssueCommentEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableIssueCommentEvent(this.repository, value, this.eventInstallation, this.action, this.changes, this.issue, this.comment);
    }

    public final ImmutableIssueCommentEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableIssueCommentEvent(this.repository, this.sender, value, this.action, this.changes, this.issue, this.comment);
    }

    public final ImmutableIssueCommentEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutableIssueCommentEvent(this.repository, this.sender, this.eventInstallation, value, this.changes, this.issue, this.comment);
    }

    public final ImmutableIssueCommentEvent withChanges(Changes value) {
        Changes newValue = Objects.requireNonNull(value, "changes");
        if (this.changes == newValue) {
            return this;
        }
        return new ImmutableIssueCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, newValue, this.issue, this.comment);
    }

    public final ImmutableIssueCommentEvent withChanges(Optional<? extends Changes> optional) {
        Changes value = optional.orElse(null);
        if (this.changes == value) {
            return this;
        }
        return new ImmutableIssueCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, value, this.issue, this.comment);
    }

    public final ImmutableIssueCommentEvent withIssue(@Nullable Issue value) {
        if (this.issue == value) {
            return this;
        }
        return new ImmutableIssueCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, this.changes, value, this.comment);
    }

    public final ImmutableIssueCommentEvent withComment(@Nullable Comment value) {
        if (this.comment == value) {
            return this;
        }
        return new ImmutableIssueCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, this.changes, this.issue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIssueCommentEvent && this.equalTo((ImmutableIssueCommentEvent)another);
    }

    private boolean equalTo(ImmutableIssueCommentEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.action, another.action) && Objects.equals(this.changes, another.changes) && Objects.equals(this.issue, another.issue) && Objects.equals(this.comment, another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.changes);
        h += (h << 5) + Objects.hashCode(this.issue);
        h += (h << 5) + Objects.hashCode(this.comment);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IssueCommentEvent{");
        if (this.repository != null) {
            builder.append("repository=").append(this.repository);
        }
        if (this.sender != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("sender=").append(this.sender);
        }
        if (this.eventInstallation != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("eventInstallation=").append(this.eventInstallation);
        }
        if (this.action != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("action=").append(this.action);
        }
        if (this.changes != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("changes=").append(this.changes);
        }
        if (this.issue != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("issue=").append(this.issue);
        }
        if (this.comment != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("comment=").append(this.comment);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIssueCommentEvent fromJson(Json json) {
        Builder builder = ImmutableIssueCommentEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.changes != null) {
            builder.changes(json.changes);
        }
        if (json.issue != null) {
            builder.issue(json.issue);
        }
        if (json.comment != null) {
            builder.comment(json.comment);
        }
        return builder.build();
    }

    public static ImmutableIssueCommentEvent copyOf(IssueCommentEvent instance) {
        if (instance instanceof ImmutableIssueCommentEvent) {
            return (ImmutableIssueCommentEvent)instance;
        }
        return ImmutableIssueCommentEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IssueCommentEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String action;
        @Nullable
        private Changes changes;
        @Nullable
        private Issue issue;
        @Nullable
        private Comment comment;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IssueCommentEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            if (object instanceof IssueCommentEvent) {
                Issue issueValue;
                Comment commentValue;
                String actionValue;
                instance = (IssueCommentEvent)object;
                Optional<Changes> changesOptional = instance.changes();
                if (changesOptional.isPresent()) {
                    this.changes(changesOptional);
                }
                if ((actionValue = instance.action()) != null) {
                    this.action(actionValue);
                }
                if ((commentValue = instance.comment()) != null) {
                    this.comment(commentValue);
                }
                if ((issueValue = instance.issue()) != null) {
                    this.issue(issueValue);
                }
            }
            if (object instanceof BaseEvent) {
                EventInstallation eventInstallationValue;
                User senderValue;
                instance = (BaseEvent)object;
                Repository repositoryValue = instance.repository();
                if (repositoryValue != null) {
                    this.repository(repositoryValue);
                }
                if ((senderValue = instance.sender()) != null) {
                    this.sender(senderValue);
                }
                if ((eventInstallationValue = instance.eventInstallation()) != null) {
                    this.eventInstallation(eventInstallationValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder changes(Changes changes) {
            this.changes = Objects.requireNonNull(changes, "changes");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder changes(Optional<? extends Changes> changes) {
            this.changes = changes.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder issue(@Nullable Issue issue) {
            this.issue = issue;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder comment(@Nullable Comment comment) {
            this.comment = comment;
            return this;
        }

        public ImmutableIssueCommentEvent build() {
            return new ImmutableIssueCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, this.changes, this.issue, this.comment);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IssueCommentEvent", generator="Immutables")
    static final class Json
    implements IssueCommentEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String action;
        @Nullable
        Optional<Changes> changes = Optional.empty();
        @Nullable
        Issue issue;
        @Nullable
        Comment comment;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setChanges(Optional<Changes> changes) {
            this.changes = changes;
        }

        @JsonProperty
        public void setIssue(@Nullable Issue issue) {
            this.issue = issue;
        }

        @JsonProperty
        public void setComment(@Nullable Comment comment) {
            this.comment = comment;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Changes> changes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Issue issue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comment comment() {
            throw new UnsupportedOperationException();
        }
    }
}

