/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.IssuesEvent;
import com.spotify.github.v3.issues.Issue;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IssuesEvent", generator="Immutables")
@Immutable
public final class ImmutableIssuesEvent
implements IssuesEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String action;
    @Nullable
    private final Issue issue;

    private ImmutableIssuesEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String action, @Nullable Issue issue) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.action = action;
        this.issue = issue;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    @Nullable
    public Issue issue() {
        return this.issue;
    }

    public final ImmutableIssuesEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableIssuesEvent(value, this.sender, this.eventInstallation, this.action, this.issue);
    }

    public final ImmutableIssuesEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableIssuesEvent(this.repository, value, this.eventInstallation, this.action, this.issue);
    }

    public final ImmutableIssuesEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableIssuesEvent(this.repository, this.sender, value, this.action, this.issue);
    }

    public final ImmutableIssuesEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutableIssuesEvent(this.repository, this.sender, this.eventInstallation, value, this.issue);
    }

    public final ImmutableIssuesEvent withIssue(@Nullable Issue value) {
        if (this.issue == value) {
            return this;
        }
        return new ImmutableIssuesEvent(this.repository, this.sender, this.eventInstallation, this.action, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIssuesEvent && this.equalTo((ImmutableIssuesEvent)another);
    }

    private boolean equalTo(ImmutableIssuesEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.action, another.action) && Objects.equals(this.issue, another.issue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.issue);
        return h;
    }

    public String toString() {
        return "IssuesEvent{repository=" + this.repository + ", sender=" + this.sender + ", eventInstallation=" + this.eventInstallation + ", action=" + this.action + ", issue=" + this.issue + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIssuesEvent fromJson(Json json) {
        Builder builder = ImmutableIssuesEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.issue != null) {
            builder.issue(json.issue);
        }
        return builder.build();
    }

    public static ImmutableIssuesEvent copyOf(IssuesEvent instance) {
        if (instance instanceof ImmutableIssuesEvent) {
            return (ImmutableIssuesEvent)instance;
        }
        return ImmutableIssuesEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IssuesEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String action;
        @Nullable
        private Issue issue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IssuesEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            if (object instanceof IssuesEvent) {
                String actionValue;
                instance = (IssuesEvent)object;
                Issue issueValue = instance.issue();
                if (issueValue != null) {
                    this.issue(issueValue);
                }
                if ((actionValue = instance.action()) != null) {
                    this.action(actionValue);
                }
            }
            if (object instanceof BaseEvent) {
                EventInstallation eventInstallationValue;
                User senderValue;
                instance = (BaseEvent)object;
                Repository repositoryValue = instance.repository();
                if (repositoryValue != null) {
                    this.repository(repositoryValue);
                }
                if ((senderValue = instance.sender()) != null) {
                    this.sender(senderValue);
                }
                if ((eventInstallationValue = instance.eventInstallation()) != null) {
                    this.eventInstallation(eventInstallationValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder issue(@Nullable Issue issue) {
            this.issue = issue;
            return this;
        }

        public ImmutableIssuesEvent build() {
            return new ImmutableIssuesEvent(this.repository, this.sender, this.eventInstallation, this.action, this.issue);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IssuesEvent", generator="Immutables")
    static final class Json
    implements IssuesEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String action;
        @Nullable
        Issue issue;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setIssue(@Nullable Issue issue) {
            this.issue = issue;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Issue issue() {
            throw new UnsupportedOperationException();
        }
    }
}

