/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.Annotation;
import com.spotify.github.v3.checks.CheckRunImage;
import com.spotify.github.v3.checks.CheckRunOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckRunOutput", generator="Immutables")
@Immutable
public final class ImmutableCheckRunOutput
implements CheckRunOutput {
    @Nullable
    private final String title;
    @Nullable
    private final String summary;
    @Nullable
    private final String text;
    private final List<CheckRunImage> images;
    private final List<Annotation> annotations;
    @Nullable
    private final Integer annotationsCount;
    @Nullable
    private final String annotationsUrl;

    private ImmutableCheckRunOutput(@Nullable String title, @Nullable String summary, @Nullable String text, List<CheckRunImage> images, List<Annotation> annotations, @Nullable Integer annotationsCount, @Nullable String annotationsUrl) {
        this.title = title;
        this.summary = summary;
        this.text = text;
        this.images = images;
        this.annotations = annotations;
        this.annotationsCount = annotationsCount;
        this.annotationsUrl = annotationsUrl;
    }

    @Override
    @JsonProperty
    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public Optional<String> summary() {
        return Optional.ofNullable(this.summary);
    }

    @Override
    @JsonProperty
    public Optional<String> text() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public List<CheckRunImage> images() {
        return this.images;
    }

    @Override
    @JsonProperty
    public List<Annotation> annotations() {
        return this.annotations;
    }

    @Override
    @JsonProperty
    public Optional<Integer> annotationsCount() {
        return Optional.ofNullable(this.annotationsCount);
    }

    @Override
    @JsonProperty
    public Optional<String> annotationsUrl() {
        return Optional.ofNullable(this.annotationsUrl);
    }

    public final ImmutableCheckRunOutput withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(newValue, this.summary, this.text, this.images, this.annotations, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(value, this.summary, this.text, this.images, this.annotations, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withSummary(String value) {
        String newValue = Objects.requireNonNull(value, "summary");
        if (Objects.equals(this.summary, newValue)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, newValue, this.text, this.images, this.annotations, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withSummary(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.summary, value)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, value, this.text, this.images, this.annotations, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, newValue, this.images, this.annotations, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, value, this.images, this.annotations, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withImages(CheckRunImage ... elements) {
        List<CheckRunImage> newValue = ImmutableCheckRunOutput.createUnmodifiableList(false, ImmutableCheckRunOutput.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, newValue, this.annotations, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withImages(Iterable<? extends CheckRunImage> elements) {
        if (this.images == elements) {
            return this;
        }
        List<CheckRunImage> newValue = ImmutableCheckRunOutput.createUnmodifiableList(false, ImmutableCheckRunOutput.createSafeList(elements, true, false));
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, newValue, this.annotations, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withAnnotations(Annotation ... elements) {
        List<Annotation> newValue = ImmutableCheckRunOutput.createUnmodifiableList(false, ImmutableCheckRunOutput.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, this.images, newValue, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withAnnotations(Iterable<? extends Annotation> elements) {
        if (this.annotations == elements) {
            return this;
        }
        List<Annotation> newValue = ImmutableCheckRunOutput.createUnmodifiableList(false, ImmutableCheckRunOutput.createSafeList(elements, true, false));
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, this.images, newValue, this.annotationsCount, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withAnnotationsCount(int value) {
        Integer newValue = value;
        if (Objects.equals(this.annotationsCount, newValue)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, this.images, this.annotations, newValue, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withAnnotationsCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.annotationsCount, value)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, this.images, this.annotations, value, this.annotationsUrl));
    }

    public final ImmutableCheckRunOutput withAnnotationsUrl(String value) {
        String newValue = Objects.requireNonNull(value, "annotationsUrl");
        if (Objects.equals(this.annotationsUrl, newValue)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, this.images, this.annotations, this.annotationsCount, newValue));
    }

    public final ImmutableCheckRunOutput withAnnotationsUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.annotationsUrl, value)) {
            return this;
        }
        return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, this.images, this.annotations, this.annotationsCount, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckRunOutput && this.equalTo((ImmutableCheckRunOutput)another);
    }

    private boolean equalTo(ImmutableCheckRunOutput another) {
        return Objects.equals(this.title, another.title) && Objects.equals(this.summary, another.summary) && Objects.equals(this.text, another.text) && this.images.equals(another.images) && this.annotations.equals(another.annotations) && Objects.equals(this.annotationsCount, another.annotationsCount) && Objects.equals(this.annotationsUrl, another.annotationsUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.summary);
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + this.images.hashCode();
        h += (h << 5) + this.annotations.hashCode();
        h += (h << 5) + Objects.hashCode(this.annotationsCount);
        h += (h << 5) + Objects.hashCode(this.annotationsUrl);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CheckRunOutput{");
        if (this.title != null) {
            builder.append("title=").append(this.title);
        }
        if (this.summary != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("summary=").append(this.summary);
        }
        if (this.text != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("text=").append(this.text);
        }
        if (builder.length() > 15) {
            builder.append(", ");
        }
        builder.append("images=").append(this.images);
        builder.append(", ");
        builder.append("annotations=").append(this.annotations);
        if (this.annotationsCount != null) {
            builder.append(", ");
            builder.append("annotationsCount=").append(this.annotationsCount);
        }
        if (this.annotationsUrl != null) {
            builder.append(", ");
            builder.append("annotationsUrl=").append(this.annotationsUrl);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckRunOutput fromJson(Json json) {
        Builder builder = ImmutableCheckRunOutput.builder();
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.summary != null) {
            builder.summary(json.summary);
        }
        if (json.text != null) {
            builder.text(json.text);
        }
        if (json.images != null) {
            builder.addAllImages(json.images);
        }
        if (json.annotations != null) {
            builder.addAllAnnotations(json.annotations);
        }
        if (json.annotationsCount != null) {
            builder.annotationsCount(json.annotationsCount);
        }
        if (json.annotationsUrl != null) {
            builder.annotationsUrl(json.annotationsUrl);
        }
        return builder.build();
    }

    private static ImmutableCheckRunOutput validate(ImmutableCheckRunOutput instance) {
        instance.check();
        return instance;
    }

    public static ImmutableCheckRunOutput copyOf(CheckRunOutput instance) {
        if (instance instanceof ImmutableCheckRunOutput) {
            return (ImmutableCheckRunOutput)instance;
        }
        return ImmutableCheckRunOutput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CheckRunOutput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String title;
        @Nullable
        private String summary;
        @Nullable
        private String text;
        private List<CheckRunImage> images = new ArrayList<CheckRunImage>();
        private List<Annotation> annotations = new ArrayList<Annotation>();
        @Nullable
        private Integer annotationsCount;
        @Nullable
        private String annotationsUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunOutput instance) {
            Optional<String> annotationsUrlOptional;
            Optional<String> textOptional;
            Optional<String> summaryOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> titleOptional = instance.title();
            if (titleOptional.isPresent()) {
                this.title(titleOptional);
            }
            if ((summaryOptional = instance.summary()).isPresent()) {
                this.summary(summaryOptional);
            }
            if ((textOptional = instance.text()).isPresent()) {
                this.text(textOptional);
            }
            this.addAllImages(instance.images());
            this.addAllAnnotations(instance.annotations());
            Optional<Integer> annotationsCountOptional = instance.annotationsCount();
            if (annotationsCountOptional.isPresent()) {
                this.annotationsCount(annotationsCountOptional);
            }
            if ((annotationsUrlOptional = instance.annotationsUrl()).isPresent()) {
                this.annotationsUrl(annotationsUrlOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder summary(String summary) {
            this.summary = Objects.requireNonNull(summary, "summary");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder summary(Optional<String> summary) {
            this.summary = summary.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder text(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(CheckRunImage element) {
            this.images.add(Objects.requireNonNull(element, "images element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(CheckRunImage ... elements) {
            for (CheckRunImage element : elements) {
                this.images.add(Objects.requireNonNull(element, "images element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder images(Iterable<? extends CheckRunImage> elements) {
            this.images.clear();
            return this.addAllImages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllImages(Iterable<? extends CheckRunImage> elements) {
            for (CheckRunImage checkRunImage : elements) {
                this.images.add(Objects.requireNonNull(checkRunImage, "images element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnnotations(Annotation element) {
            this.annotations.add(Objects.requireNonNull(element, "annotations element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnnotations(Annotation ... elements) {
            for (Annotation element : elements) {
                this.annotations.add(Objects.requireNonNull(element, "annotations element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder annotations(Iterable<? extends Annotation> elements) {
            this.annotations.clear();
            return this.addAllAnnotations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAnnotations(Iterable<? extends Annotation> elements) {
            for (Annotation annotation : elements) {
                this.annotations.add(Objects.requireNonNull(annotation, "annotations element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder annotationsCount(int annotationsCount) {
            this.annotationsCount = annotationsCount;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder annotationsCount(Optional<Integer> annotationsCount) {
            this.annotationsCount = annotationsCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder annotationsUrl(String annotationsUrl) {
            this.annotationsUrl = Objects.requireNonNull(annotationsUrl, "annotationsUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder annotationsUrl(Optional<String> annotationsUrl) {
            this.annotationsUrl = annotationsUrl.orElse(null);
            return this;
        }

        public ImmutableCheckRunOutput build() {
            return ImmutableCheckRunOutput.validate(new ImmutableCheckRunOutput(this.title, this.summary, this.text, ImmutableCheckRunOutput.createUnmodifiableList(true, this.images), ImmutableCheckRunOutput.createUnmodifiableList(true, this.annotations), this.annotationsCount, this.annotationsUrl));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckRunOutput", generator="Immutables")
    static final class Json
    implements CheckRunOutput {
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        Optional<String> summary = Optional.empty();
        @Nullable
        Optional<String> text = Optional.empty();
        @Nullable
        List<CheckRunImage> images = Collections.emptyList();
        @Nullable
        List<Annotation> annotations = Collections.emptyList();
        @Nullable
        Optional<Integer> annotationsCount = Optional.empty();
        @Nullable
        Optional<String> annotationsUrl = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setSummary(Optional<String> summary) {
            this.summary = summary;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setImages(List<CheckRunImage> images) {
            this.images = images;
        }

        @JsonProperty
        public void setAnnotations(List<Annotation> annotations) {
            this.annotations = annotations;
        }

        @JsonProperty
        public void setAnnotationsCount(Optional<Integer> annotationsCount) {
            this.annotationsCount = annotationsCount;
        }

        @JsonProperty
        public void setAnnotationsUrl(Optional<String> annotationsUrl) {
            this.annotationsUrl = annotationsUrl;
        }

        @Override
        public Optional<String> title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> summary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> text() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CheckRunImage> images() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Annotation> annotations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> annotationsCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> annotationsUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

