/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.checks.Installation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Installation", generator="Immutables")
@Immutable
public final class ImmutableInstallation
implements Installation {
    private final int id;
    private final User account;
    private final String accessTokensUrl;
    private final String repositoriesUrl;
    @Nullable
    private final String htmlUrl;
    private final int appId;
    private final int targetId;
    private final String targetType;
    private final Map<String, String> permissions;
    private final List<String> events;
    @Nullable
    private final String singleFileName;
    @Nullable
    private final String repositorySelection;

    private ImmutableInstallation(int id, User account, String accessTokensUrl, String repositoriesUrl, @Nullable String htmlUrl, int appId, int targetId, String targetType, Map<String, String> permissions, List<String> events, @Nullable String singleFileName, @Nullable String repositorySelection) {
        this.id = id;
        this.account = account;
        this.accessTokensUrl = accessTokensUrl;
        this.repositoriesUrl = repositoriesUrl;
        this.htmlUrl = htmlUrl;
        this.appId = appId;
        this.targetId = targetId;
        this.targetType = targetType;
        this.permissions = permissions;
        this.events = events;
        this.singleFileName = singleFileName;
        this.repositorySelection = repositorySelection;
    }

    @Override
    @JsonProperty
    public int id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public User account() {
        return this.account;
    }

    @Override
    @JsonProperty
    public String accessTokensUrl() {
        return this.accessTokensUrl;
    }

    @Override
    @JsonProperty
    public String repositoriesUrl() {
        return this.repositoriesUrl;
    }

    @Override
    @JsonProperty
    public Optional<String> htmlUrl() {
        return Optional.ofNullable(this.htmlUrl);
    }

    @Override
    @JsonProperty
    public int appId() {
        return this.appId;
    }

    @Override
    @JsonProperty
    public int targetId() {
        return this.targetId;
    }

    @Override
    @JsonProperty
    public String targetType() {
        return this.targetType;
    }

    @Override
    @JsonProperty
    public Map<String, String> permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty
    public List<String> events() {
        return this.events;
    }

    @Override
    @JsonProperty
    public Optional<String> singleFileName() {
        return Optional.ofNullable(this.singleFileName);
    }

    @Override
    @JsonProperty
    public Optional<String> repositorySelection() {
        return Optional.ofNullable(this.repositorySelection);
    }

    public final ImmutableInstallation withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInstallation(value, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withAccount(User value) {
        if (this.account == value) {
            return this;
        }
        User newValue = Objects.requireNonNull(value, "account");
        return new ImmutableInstallation(this.id, newValue, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withAccessTokensUrl(String value) {
        String newValue = Objects.requireNonNull(value, "accessTokensUrl");
        if (this.accessTokensUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, newValue, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withRepositoriesUrl(String value) {
        String newValue = Objects.requireNonNull(value, "repositoriesUrl");
        if (this.repositoriesUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, newValue, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withHtmlUrl(String value) {
        String newValue = Objects.requireNonNull(value, "htmlUrl");
        if (Objects.equals(this.htmlUrl, newValue)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, newValue, this.appId, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withHtmlUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.htmlUrl, value)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, value, this.appId, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withAppId(int value) {
        if (this.appId == value) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, value, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withTargetId(int value) {
        if (this.targetId == value) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, value, this.targetType, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withTargetType(String value) {
        String newValue = Objects.requireNonNull(value, "targetType");
        if (this.targetType.equals(newValue)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, newValue, this.permissions, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withPermissions(Map<String, ? extends String> entries) {
        if (this.permissions == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableInstallation.createUnmodifiableMap(true, false, entries);
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, newValue, this.events, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withEvents(String ... elements) {
        List<String> newValue = ImmutableInstallation.createUnmodifiableList(false, ImmutableInstallation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, newValue, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withEvents(Iterable<String> elements) {
        if (this.events == elements) {
            return this;
        }
        List<String> newValue = ImmutableInstallation.createUnmodifiableList(false, ImmutableInstallation.createSafeList(elements, true, false));
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, newValue, this.singleFileName, this.repositorySelection);
    }

    public final ImmutableInstallation withSingleFileName(String value) {
        String newValue = Objects.requireNonNull(value, "singleFileName");
        if (Objects.equals(this.singleFileName, newValue)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, this.events, newValue, this.repositorySelection);
    }

    public final ImmutableInstallation withSingleFileName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.singleFileName, value)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, this.events, value, this.repositorySelection);
    }

    public final ImmutableInstallation withRepositorySelection(String value) {
        String newValue = Objects.requireNonNull(value, "repositorySelection");
        if (Objects.equals(this.repositorySelection, newValue)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, newValue);
    }

    public final ImmutableInstallation withRepositorySelection(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.repositorySelection, value)) {
            return this;
        }
        return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, this.permissions, this.events, this.singleFileName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstallation && this.equalTo((ImmutableInstallation)another);
    }

    private boolean equalTo(ImmutableInstallation another) {
        return this.id == another.id && this.account.equals(another.account) && this.accessTokensUrl.equals(another.accessTokensUrl) && this.repositoriesUrl.equals(another.repositoriesUrl) && Objects.equals(this.htmlUrl, another.htmlUrl) && this.appId == another.appId && this.targetId == another.targetId && this.targetType.equals(another.targetType) && this.permissions.equals(another.permissions) && this.events.equals(another.events) && Objects.equals(this.singleFileName, another.singleFileName) && Objects.equals(this.repositorySelection, another.repositorySelection);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.accessTokensUrl.hashCode();
        h += (h << 5) + this.repositoriesUrl.hashCode();
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + this.appId;
        h += (h << 5) + this.targetId;
        h += (h << 5) + this.targetType.hashCode();
        h += (h << 5) + this.permissions.hashCode();
        h += (h << 5) + this.events.hashCode();
        h += (h << 5) + Objects.hashCode(this.singleFileName);
        h += (h << 5) + Objects.hashCode(this.repositorySelection);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Installation{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("account=").append(this.account);
        builder.append(", ");
        builder.append("accessTokensUrl=").append(this.accessTokensUrl);
        builder.append(", ");
        builder.append("repositoriesUrl=").append(this.repositoriesUrl);
        if (this.htmlUrl != null) {
            builder.append(", ");
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        builder.append(", ");
        builder.append("appId=").append(this.appId);
        builder.append(", ");
        builder.append("targetId=").append(this.targetId);
        builder.append(", ");
        builder.append("targetType=").append(this.targetType);
        builder.append(", ");
        builder.append("permissions=").append(this.permissions);
        builder.append(", ");
        builder.append("events=").append(this.events);
        if (this.singleFileName != null) {
            builder.append(", ");
            builder.append("singleFileName=").append(this.singleFileName);
        }
        if (this.repositorySelection != null) {
            builder.append(", ");
            builder.append("repositorySelection=").append(this.repositorySelection);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInstallation fromJson(Json json) {
        Builder builder = ImmutableInstallation.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.accessTokensUrl != null) {
            builder.accessTokensUrl(json.accessTokensUrl);
        }
        if (json.repositoriesUrl != null) {
            builder.repositoriesUrl(json.repositoriesUrl);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.appIdIsSet) {
            builder.appId(json.appId);
        }
        if (json.targetIdIsSet) {
            builder.targetId(json.targetId);
        }
        if (json.targetType != null) {
            builder.targetType(json.targetType);
        }
        if (json.permissions != null) {
            builder.putAllPermissions(json.permissions);
        }
        if (json.events != null) {
            builder.addAllEvents(json.events);
        }
        if (json.singleFileName != null) {
            builder.singleFileName(json.singleFileName);
        }
        if (json.repositorySelection != null) {
            builder.repositorySelection(json.repositorySelection);
        }
        return builder.build();
    }

    public static ImmutableInstallation copyOf(Installation instance) {
        if (instance instanceof ImmutableInstallation) {
            return (ImmutableInstallation)instance;
        }
        return ImmutableInstallation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Installation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCOUNT = 2L;
        private static final long INIT_BIT_ACCESS_TOKENS_URL = 4L;
        private static final long INIT_BIT_REPOSITORIES_URL = 8L;
        private static final long INIT_BIT_APP_ID = 16L;
        private static final long INIT_BIT_TARGET_ID = 32L;
        private static final long INIT_BIT_TARGET_TYPE = 64L;
        private long initBits = 127L;
        private int id;
        @Nullable
        private User account;
        @Nullable
        private String accessTokensUrl;
        @Nullable
        private String repositoriesUrl;
        @Nullable
        private String htmlUrl;
        private int appId;
        private int targetId;
        @Nullable
        private String targetType;
        private Map<String, String> permissions = new LinkedHashMap<String, String>();
        private List<String> events = new ArrayList<String>();
        @Nullable
        private String singleFileName;
        @Nullable
        private String repositorySelection;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Installation instance) {
            Optional<String> repositorySelectionOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.account(instance.account());
            this.accessTokensUrl(instance.accessTokensUrl());
            this.repositoriesUrl(instance.repositoriesUrl());
            Optional<String> htmlUrlOptional = instance.htmlUrl();
            if (htmlUrlOptional.isPresent()) {
                this.htmlUrl(htmlUrlOptional);
            }
            this.appId(instance.appId());
            this.targetId(instance.targetId());
            this.targetType(instance.targetType());
            this.putAllPermissions(instance.permissions());
            this.addAllEvents(instance.events());
            Optional<String> singleFileNameOptional = instance.singleFileName();
            if (singleFileNameOptional.isPresent()) {
                this.singleFileName(singleFileNameOptional);
            }
            if ((repositorySelectionOptional = instance.repositorySelection()).isPresent()) {
                this.repositorySelection(repositorySelectionOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder account(User account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder accessTokensUrl(String accessTokensUrl) {
            this.accessTokensUrl = Objects.requireNonNull(accessTokensUrl, "accessTokensUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repositoriesUrl(String repositoriesUrl) {
            this.repositoriesUrl = Objects.requireNonNull(repositoriesUrl, "repositoriesUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder htmlUrl(String htmlUrl) {
            this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(Optional<String> htmlUrl) {
            this.htmlUrl = htmlUrl.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder appId(int appId) {
            this.appId = appId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder targetId(int targetId) {
            this.targetId = targetId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder targetType(String targetType) {
            this.targetType = Objects.requireNonNull(targetType, "targetType");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPermissions(String key, String value) {
            this.permissions.put(Objects.requireNonNull(key, "permissions key"), Objects.requireNonNull(value, "permissions value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPermissions(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.permissions.put(Objects.requireNonNull(k, "permissions key"), Objects.requireNonNull(v, "permissions value"));
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder permissions(Map<String, ? extends String> entries) {
            this.permissions.clear();
            return this.putAllPermissions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllPermissions(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.permissions.put(Objects.requireNonNull(k, "permissions key"), Objects.requireNonNull(v, "permissions value"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String element) {
            this.events.add(Objects.requireNonNull(element, "events element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String ... elements) {
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder events(Iterable<String> elements) {
            this.events.clear();
            return this.addAllEvents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEvents(Iterable<String> elements) {
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder singleFileName(String singleFileName) {
            this.singleFileName = Objects.requireNonNull(singleFileName, "singleFileName");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder singleFileName(Optional<String> singleFileName) {
            this.singleFileName = singleFileName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositorySelection(String repositorySelection) {
            this.repositorySelection = Objects.requireNonNull(repositorySelection, "repositorySelection");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repositorySelection(Optional<String> repositorySelection) {
            this.repositorySelection = repositorySelection.orElse(null);
            return this;
        }

        public ImmutableInstallation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstallation(this.id, this.account, this.accessTokensUrl, this.repositoriesUrl, this.htmlUrl, this.appId, this.targetId, this.targetType, ImmutableInstallation.createUnmodifiableMap(false, false, this.permissions), ImmutableInstallation.createUnmodifiableList(true, this.events), this.singleFileName, this.repositorySelection);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("accessTokensUrl");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("repositoriesUrl");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("appId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("targetId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("targetType");
            }
            return "Cannot build Installation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Installation", generator="Immutables")
    static final class Json
    implements Installation {
        int id;
        boolean idIsSet;
        @Nullable
        User account;
        @Nullable
        String accessTokensUrl;
        @Nullable
        String repositoriesUrl;
        @Nullable
        Optional<String> htmlUrl = Optional.empty();
        int appId;
        boolean appIdIsSet;
        int targetId;
        boolean targetIdIsSet;
        @Nullable
        String targetType;
        @Nullable
        Map<String, String> permissions = Collections.emptyMap();
        @Nullable
        List<String> events = Collections.emptyList();
        @Nullable
        Optional<String> singleFileName = Optional.empty();
        @Nullable
        Optional<String> repositorySelection = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(int id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty
        public void setAccount(User account) {
            this.account = account;
        }

        @JsonProperty
        public void setAccessTokensUrl(String accessTokensUrl) {
            this.accessTokensUrl = accessTokensUrl;
        }

        @JsonProperty
        public void setRepositoriesUrl(String repositoriesUrl) {
            this.repositoriesUrl = repositoriesUrl;
        }

        @JsonProperty
        public void setHtmlUrl(Optional<String> htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setAppId(int appId) {
            this.appId = appId;
            this.appIdIsSet = true;
        }

        @JsonProperty
        public void setTargetId(int targetId) {
            this.targetId = targetId;
            this.targetIdIsSet = true;
        }

        @JsonProperty
        public void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @JsonProperty
        public void setPermissions(Map<String, String> permissions) {
            this.permissions = permissions;
        }

        @JsonProperty
        public void setEvents(List<String> events) {
            this.events = events;
        }

        @JsonProperty
        public void setSingleFileName(Optional<String> singleFileName) {
            this.singleFileName = singleFileName;
        }

        @JsonProperty
        public void setRepositorySelection(Optional<String> repositorySelection) {
            this.repositorySelection = repositorySelection;
        }

        @Override
        public int id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String accessTokensUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String repositoriesUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int appId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int targetId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String targetType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> events() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> singleFileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> repositorySelection() {
            throw new UnsupportedOperationException();
        }
    }
}

