/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.spotify.github.Tracer;
import com.spotify.github.jackson.Json;
import com.spotify.github.v3.Team;
import com.spotify.github.v3.User;
import com.spotify.github.v3.checks.AccessToken;
import com.spotify.github.v3.clients.ChecksClient;
import com.spotify.github.v3.clients.GitDataClient;
import com.spotify.github.v3.clients.JwtTokenIssuer;
import com.spotify.github.v3.clients.NoopTracer;
import com.spotify.github.v3.clients.OrganisationClient;
import com.spotify.github.v3.clients.RepositoryClient;
import com.spotify.github.v3.clients.SearchClient;
import com.spotify.github.v3.comment.Comment;
import com.spotify.github.v3.exceptions.ReadOnlyRepositoryException;
import com.spotify.github.v3.exceptions.RequestNotOkException;
import com.spotify.github.v3.git.Reference;
import com.spotify.github.v3.orgs.TeamInvitation;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.prs.Review;
import com.spotify.github.v3.prs.ReviewRequests;
import com.spotify.github.v3.repos.Branch;
import com.spotify.github.v3.repos.CommitItem;
import com.spotify.github.v3.repos.FolderContent;
import com.spotify.github.v3.repos.Repository;
import com.spotify.github.v3.repos.RepositoryInvitation;
import com.spotify.github.v3.repos.Status;
import com.spotify.githubclient.shade.okhttp3.Call;
import com.spotify.githubclient.shade.okhttp3.Callback;
import com.spotify.githubclient.shade.okhttp3.MediaType;
import com.spotify.githubclient.shade.okhttp3.OkHttpClient;
import com.spotify.githubclient.shade.okhttp3.Request;
import com.spotify.githubclient.shade.okhttp3.RequestBody;
import com.spotify.githubclient.shade.okhttp3.Response;
import com.spotify.githubclient.shade.okhttp3.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubClient {
    private static final int EXPIRY_MARGIN_IN_MINUTES = 5;
    private Tracer tracer = NoopTracer.INSTANCE;
    static final Consumer<Response> IGNORE_RESPONSE_CONSUMER = response -> {
        if (response.body() != null) {
            response.body().close();
        }
    };
    static final TypeReference<List<Comment>> LIST_COMMENT_TYPE_REFERENCE = new TypeReference<List<Comment>>(){};
    static final TypeReference<List<Repository>> LIST_REPOSITORY = new TypeReference<List<Repository>>(){};
    static final TypeReference<List<CommitItem>> LIST_COMMIT_TYPE_REFERENCE = new TypeReference<List<CommitItem>>(){};
    static final TypeReference<List<Review>> LIST_REVIEW_TYPE_REFERENCE = new TypeReference<List<Review>>(){};
    static final TypeReference<ReviewRequests> LIST_REVIEW_REQUEST_TYPE_REFERENCE = new TypeReference<ReviewRequests>(){};
    static final TypeReference<List<Status>> LIST_STATUS_TYPE_REFERENCE = new TypeReference<List<Status>>(){};
    static final TypeReference<List<FolderContent>> LIST_FOLDERCONTENT_TYPE_REFERENCE = new TypeReference<List<FolderContent>>(){};
    static final TypeReference<List<PullRequestItem>> LIST_PR_TYPE_REFERENCE = new TypeReference<List<PullRequestItem>>(){};
    static final TypeReference<List<Branch>> LIST_BRANCHES = new TypeReference<List<Branch>>(){};
    static final TypeReference<List<Reference>> LIST_REFERENCES = new TypeReference<List<Reference>>(){};
    static final TypeReference<List<RepositoryInvitation>> LIST_REPOSITORY_INVITATION = new TypeReference<List<RepositoryInvitation>>(){};
    static final TypeReference<List<Team>> LIST_TEAMS = new TypeReference<List<Team>>(){};
    static final TypeReference<List<User>> LIST_TEAM_MEMBERS = new TypeReference<List<User>>(){};
    static final TypeReference<List<TeamInvitation>> LIST_PENDING_TEAM_INVITATIONS = new TypeReference<List<TeamInvitation>>(){};
    private static final String GET_ACCESS_TOKEN_URL = "app/installations/%s/access_tokens";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int PERMANENT_REDIRECT = 301;
    private static final int TEMPORARY_REDIRECT = 307;
    private static final int FORBIDDEN = 403;
    private final URI baseUrl;
    private final Json json = Json.create();
    private final OkHttpClient client;
    private final String token;
    private final byte[] privateKey;
    private final Integer appId;
    private final Integer installationId;
    private final Map<Integer, AccessToken> installationTokens;

    private GitHubClient(OkHttpClient client, URI baseUrl, String accessToken, byte[] privateKey, Integer appId, Integer installationId) {
        this.baseUrl = baseUrl;
        this.token = accessToken;
        this.client = client;
        this.privateKey = privateKey;
        this.appId = appId;
        this.installationId = installationId;
        this.installationTokens = new HashMap<Integer, AccessToken>();
    }

    public static GitHubClient create(URI baseUrl, String token) {
        return new GitHubClient(new OkHttpClient(), baseUrl, token, null, null, null);
    }

    public static GitHubClient create(URI baseUrl, File privateKey, Integer appId) {
        return GitHubClient.createOrThrow(new OkHttpClient(), baseUrl, privateKey, appId, null);
    }

    public static GitHubClient create(URI baseUrl, byte[] privateKey, Integer appId) {
        return new GitHubClient(new OkHttpClient(), baseUrl, null, privateKey, appId, null);
    }

    public static GitHubClient create(URI baseUrl, File privateKey, Integer appId, Integer installationId) {
        return GitHubClient.createOrThrow(new OkHttpClient(), baseUrl, privateKey, appId, installationId);
    }

    public static GitHubClient create(URI baseUrl, byte[] privateKey, Integer appId, Integer installationId) {
        return new GitHubClient(new OkHttpClient(), baseUrl, null, privateKey, appId, installationId);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, File privateKey, Integer appId) {
        return GitHubClient.createOrThrow(httpClient, baseUrl, privateKey, appId, null);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, byte[] privateKey, Integer appId) {
        return new GitHubClient(httpClient, baseUrl, null, privateKey, appId, null);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, File privateKey, Integer appId, Integer installationId) {
        return GitHubClient.createOrThrow(httpClient, baseUrl, privateKey, appId, installationId);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, byte[] privateKey, Integer appId, Integer installationId) {
        return new GitHubClient(httpClient, baseUrl, null, privateKey, appId, installationId);
    }

    public static GitHubClient create(OkHttpClient httpClient, URI baseUrl, String token) {
        return new GitHubClient(httpClient, baseUrl, token, null, null, null);
    }

    public static GitHubClient scopeForInstallationId(GitHubClient client, int installationId) {
        if (client.getPrivateKey().isEmpty()) {
            throw new RuntimeException("Installation ID scoped client needs a private key");
        }
        return new GitHubClient(client.client, client.baseUrl, null, client.getPrivateKey().get(), client.appId, installationId);
    }

    static String responseBodyUnchecked(Response response) {
        ResponseBody body = response.body();
        try {
            String string = body.string();
            if (body != null) {
                body.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (body != null) {
                    try {
                        body.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed getting response body for: " + response, e);
            }
        }
    }

    public GitHubClient withTracer(Tracer tracer) {
        this.tracer = tracer;
        return this;
    }

    public Optional<byte[]> getPrivateKey() {
        return Optional.ofNullable(this.privateKey);
    }

    public Optional<String> getAccessToken() {
        return Optional.ofNullable(this.token);
    }

    public RepositoryClient createRepositoryClient(String owner, String repo) {
        return RepositoryClient.create(this, owner, repo);
    }

    public GitDataClient createGitDataClient(String owner, String repo) {
        return GitDataClient.create(this, owner, repo);
    }

    public SearchClient createSearchClient() {
        return SearchClient.create(this);
    }

    public ChecksClient createChecksClient(String owner, String repo) {
        return ChecksClient.create(this, owner, repo);
    }

    public OrganisationClient createOrganisationClient(String org) {
        return OrganisationClient.create(this, org);
    }

    Json json() {
        return this.json;
    }

    CompletableFuture<Response> request(String path) {
        Request request = this.requestBuilder(path).build();
        log.debug("Making request to {}", (Object)request.url().toString());
        return this.call(request);
    }

    CompletableFuture<Response> request(String path, Map<String, String> extraHeaders) {
        Request.Builder builder = this.requestBuilder(path);
        extraHeaders.forEach(builder::addHeader);
        Request request = builder.build();
        log.debug("Making request to {}", (Object)request.url().toString());
        return this.call(request);
    }

    <T> CompletableFuture<T> request(String path, Class<T> clazz) {
        Request request = this.requestBuilder(path).build();
        log.debug("Making request to {}", (Object)request.url().toString());
        return this.call(request).thenApply(body -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(body), clazz));
    }

    <T> CompletableFuture<T> request(String path, Class<T> clazz, Map<String, String> extraHeaders) {
        Request.Builder builder = this.requestBuilder(path);
        extraHeaders.forEach(builder::addHeader);
        Request request = builder.build();
        log.debug("Making request to {}", (Object)request.url().toString());
        return this.call(request).thenApply(body -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(body), clazz));
    }

    <T> CompletableFuture<T> request(String path, TypeReference<T> typeReference, Map<String, String> extraHeaders) {
        Request.Builder builder = this.requestBuilder(path);
        extraHeaders.forEach(builder::addHeader);
        Request request = builder.build();
        log.debug("Making request to {}", (Object)request.url().toString());
        return this.call(request).thenApply(response -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(response), typeReference));
    }

    <T> CompletableFuture<T> request(String path, TypeReference<T> typeReference) {
        Request request = this.requestBuilder(path).build();
        log.debug("Making request to {}", (Object)request.url().toString());
        return this.call(request).thenApply(response -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(response), typeReference));
    }

    CompletableFuture<Response> post(String path, String data) {
        Request request = this.requestBuilder(path).method("POST", RequestBody.create(MediaType.parse("application/json"), data)).build();
        log.debug("Making POST request to {}", (Object)request.url().toString());
        return this.call(request);
    }

    CompletableFuture<Response> post(String path, String data, Map<String, String> extraHeaders) {
        Request.Builder builder = this.requestBuilder(path).method("POST", RequestBody.create(MediaType.parse("application/json"), data));
        extraHeaders.forEach(builder::addHeader);
        Request request = builder.build();
        log.debug("Making POST request to {}", (Object)request.url().toString());
        return this.call(request);
    }

    <T> CompletableFuture<T> post(String path, String data, Class<T> clazz, Map<String, String> extraHeaders) {
        return this.post(path, data, extraHeaders).thenApply(response -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(response), clazz));
    }

    <T> CompletableFuture<T> post(String path, String data, Class<T> clazz) {
        return this.post(path, data).thenApply(response -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(response), clazz));
    }

    CompletableFuture<Response> put(String path, String data) {
        Request request = this.requestBuilder(path).method("PUT", RequestBody.create(MediaType.parse("application/json"), data)).build();
        log.debug("Making POST request to {}", (Object)request.url().toString());
        return this.call(request);
    }

    <T> CompletableFuture<T> put(String path, String data, Class<T> clazz) {
        return this.put(path, data).thenApply(response -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(response), clazz));
    }

    CompletableFuture<Response> patch(String path, String data) {
        Request request = this.requestBuilder(path).method("PATCH", RequestBody.create(MediaType.parse("application/json"), data)).build();
        log.debug("Making PATCH request to {}", (Object)request.url().toString());
        return this.call(request);
    }

    <T> CompletableFuture<T> patch(String path, String data, Class<T> clazz) {
        return this.patch(path, data).thenApply(response -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(response), clazz));
    }

    <T> CompletableFuture<T> patch(String path, String data, Class<T> clazz, Map<String, String> extraHeaders) {
        Request.Builder builder = this.requestBuilder(path).method("PATCH", RequestBody.create(MediaType.parse("application/json"), data));
        extraHeaders.forEach(builder::addHeader);
        Request request = builder.build();
        log.debug("Making PATCH request to {}", (Object)request.url().toString());
        return this.call(request).thenApply(response -> this.json().fromJsonUncheckedNotNull(GitHubClient.responseBodyUnchecked(response), clazz));
    }

    CompletableFuture<Response> delete(String path) {
        Request request = this.requestBuilder(path).delete().build();
        log.debug("Making DELETE request to {}", (Object)request.url().toString());
        return this.call(request);
    }

    CompletableFuture<Response> delete(String path, String data) {
        Request request = this.requestBuilder(path).method("DELETE", RequestBody.create(MediaType.parse("application/json"), data)).build();
        log.debug("Making DELETE request to {}", (Object)request.url().toString());
        return this.call(request);
    }

    String urlFor(String path) {
        return this.baseUrl.toString().replaceAll("/+$", "") + "/" + path.replaceAll("^/+", "");
    }

    private Request.Builder requestBuilder(String path) {
        Request.Builder builder = new Request.Builder().url(this.urlFor(path)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json");
        builder.addHeader("Authorization", this.getAuthorizationHeader(path));
        return builder;
    }

    private String getAuthorizationHeader(String path) {
        if (this.isJwtRequest(path) && this.getPrivateKey().isEmpty()) {
            throw new IllegalStateException("This endpoint needs a client with a private key for an App");
        }
        if (this.getAccessToken().isPresent()) {
            return String.format("token %s", this.token);
        }
        if (this.getPrivateKey().isPresent()) {
            String jwtToken;
            try {
                jwtToken = JwtTokenIssuer.fromPrivateKey(this.privateKey).getToken(this.appId);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an error generating JWT token", e);
            }
            if (this.isJwtRequest(path)) {
                return String.format("Bearer %s", jwtToken);
            }
            if (this.installationId == null) {
                throw new RuntimeException("This endpoint needs a client with an installation ID");
            }
            try {
                return String.format("token %s", this.getInstallationToken(jwtToken, this.installationId));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate access token for github app", e);
            }
        }
        throw new RuntimeException("Not possible to authenticate. ");
    }

    private boolean isJwtRequest(String path) {
        return path.startsWith("/app/installation") || path.endsWith("installation");
    }

    private String getInstallationToken(String jwtToken, int installationId) throws Exception {
        AccessToken installationToken = this.installationTokens.get(installationId);
        if (installationToken == null || this.isExpired(installationToken)) {
            log.info("Github token for installation {} is either expired or null. Trying to get a new one.", (Object)installationId);
            installationToken = this.generateInstallationToken(jwtToken, installationId);
            this.installationTokens.put(installationId, installationToken);
        }
        return installationToken.token();
    }

    private boolean isExpired(AccessToken token) {
        return token.expiresAt().isBefore(ZonedDateTime.now().plusMinutes(5L));
    }

    private AccessToken generateInstallationToken(String jwtToken, int installationId) throws Exception {
        log.info("Got JWT Token. Now getting Github access_token for installation {}", (Object)installationId);
        String url = String.format(this.urlFor(GET_ACCESS_TOKEN_URL), installationId);
        Request request = new Request.Builder().addHeader("Accept", "application/vnd.github.machine-man-preview+json").addHeader("Authorization", "Bearer " + jwtToken).url(url).method("POST", RequestBody.create(MediaType.parse("application/json"), "")).build();
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new Exception(String.format("Got non-2xx status %s when getting an access token from GitHub: %s", response.code(), response.message()));
        }
        if (response.body() == null) {
            throw new Exception(String.format("Got empty response body when getting an access token from GitHub, HTTP status was: %s", response.message()));
        }
        String text = response.body().string();
        response.body().close();
        return Json.create().fromJson(text, AccessToken.class);
    }

    private CompletableFuture<Response> call(final Request request) {
        Call call = this.client.newCall(request);
        final CompletableFuture<Response> future = new CompletableFuture<Response>();
        final AtomicBoolean redirected = new AtomicBoolean(false);
        call.enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                GitHubClient.this.processPossibleRedirects(response, redirected).handle((res, ex) -> {
                    if (Objects.nonNull(ex)) {
                        future.completeExceptionally((Throwable)ex);
                    } else if (!res.isSuccessful()) {
                        try {
                            future.completeExceptionally(GitHubClient.this.mapException((Response)res, request));
                        }
                        catch (Throwable e) {
                            future.completeExceptionally(e);
                        }
                        finally {
                            if (res.body() != null) {
                                res.body().close();
                            }
                        }
                    } else {
                        future.complete(res);
                    }
                    return res;
                });
            }
        });
        this.tracer.span(request.url().toString(), request.method(), future);
        return future;
    }

    private RequestNotOkException mapException(Response res, Request request) throws IOException {
        String bodyString;
        String string = bodyString = res.body() != null ? res.body().string() : "";
        if (res.code() == 403 && bodyString.contains("Repository was archived so is read-only")) {
            return new ReadOnlyRepositoryException(request.method(), request.url().encodedPath(), res.code(), bodyString);
        }
        return new RequestNotOkException(request.method(), request.url().encodedPath(), res.code(), bodyString);
    }

    CompletableFuture<Response> processPossibleRedirects(Response response, AtomicBoolean redirected) {
        if (response.code() >= 301 && response.code() <= 307 && !redirected.get()) {
            redirected.set(true);
            String newLocation = response.header("Location");
            Request request = this.requestBuilder(newLocation).url(newLocation).method(response.request().method(), response.request().body()).build();
            return this.call(request);
        }
        return CompletableFuture.completedFuture(response);
    }

    private static GitHubClient createOrThrow(OkHttpClient httpClient, URI baseUrl, File privateKey, Integer appId, Integer installationId) {
        try {
            return new GitHubClient(httpClient, baseUrl, null, FileUtils.readFileToByteArray((File)privateKey), appId, installationId);
        }
        catch (IOException e) {
            throw new RuntimeException("There was an error generating JWT token", e);
        }
    }
}

