/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.base.Strings;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.search.SearchIssues;
import com.spotify.github.v3.search.SearchRepositories;
import com.spotify.github.v3.search.SearchUsers;
import com.spotify.github.v3.search.requests.SearchParameters;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String USERS_URI = "/search/users";
    static final String REPOSITORIES_URI = "/search/repositories";
    static final String ISSUES_URI = "/search/issues";
    private final GitHubClient github;

    SearchClient(GitHubClient github) {
        this.github = github;
    }

    static SearchClient create(GitHubClient github) {
        return new SearchClient(github);
    }

    public CompletableFuture<SearchUsers> users(SearchParameters parameters) {
        return this.search(USERS_URI, parameters, SearchUsers.class);
    }

    public CompletableFuture<SearchIssues> issues(SearchParameters parameters) {
        return this.search(ISSUES_URI, parameters, SearchIssues.class);
    }

    public CompletableFuture<SearchRepositories> repositories(SearchParameters parameters) {
        return this.search(REPOSITORIES_URI, parameters, SearchRepositories.class);
    }

    private <T> CompletableFuture<T> search(String baseUrl, SearchParameters parameters, Class<T> clazz) {
        String serial = parameters.serialize();
        String path = baseUrl + (String)(Strings.isNullOrEmpty((String)serial) ? "" : "?" + serial);
        log.debug("Fetching search result for:" + path);
        return this.github.request(path, clazz);
    }
}

