/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.Author;
import com.spotify.github.v3.git.Commit;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Commit", generator="Immutables")
@Immutable
public final class ImmutableCommit
implements Commit {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final Author author;
    @Nullable
    private final Author committer;
    @Nullable
    private final String message;
    @Nullable
    private final ShaLink tree;
    @Nullable
    private final Integer commentCount;

    private ImmutableCommit(@Nullable String sha, @Nullable URI url, @Nullable Author author, @Nullable Author committer, @Nullable String message, @Nullable ShaLink tree, @Nullable Integer commentCount) {
        this.sha = sha;
        this.url = url;
        this.author = author;
        this.committer = committer;
        this.message = message;
        this.tree = tree;
        this.commentCount = commentCount;
    }

    @Override
    @JsonProperty
    public Optional<String> sha() {
        return Optional.ofNullable(this.sha);
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public Author author() {
        return this.author;
    }

    @Override
    @JsonProperty
    @Nullable
    public Author committer() {
        return this.committer;
    }

    @Override
    @JsonProperty
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty
    @Nullable
    public ShaLink tree() {
        return this.tree;
    }

    @Override
    @JsonProperty
    public Optional<Integer> commentCount() {
        return Optional.ofNullable(this.commentCount);
    }

    public final ImmutableCommit withSha(String value) {
        String newValue = Objects.requireNonNull(value, "sha");
        if (Objects.equals(this.sha, newValue)) {
            return this;
        }
        return new ImmutableCommit(newValue, this.url, this.author, this.committer, this.message, this.tree, this.commentCount);
    }

    public final ImmutableCommit withSha(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableCommit(value, this.url, this.author, this.committer, this.message, this.tree, this.commentCount);
    }

    public final ImmutableCommit withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, value, this.author, this.committer, this.message, this.tree, this.commentCount);
    }

    public final ImmutableCommit withAuthor(@Nullable Author value) {
        if (this.author == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, value, this.committer, this.message, this.tree, this.commentCount);
    }

    public final ImmutableCommit withCommitter(@Nullable Author value) {
        if (this.committer == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.author, value, this.message, this.tree, this.commentCount);
    }

    public final ImmutableCommit withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.author, this.committer, value, this.tree, this.commentCount);
    }

    public final ImmutableCommit withTree(@Nullable ShaLink value) {
        if (this.tree == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.author, this.committer, this.message, value, this.commentCount);
    }

    public final ImmutableCommit withCommentCount(int value) {
        Integer newValue = value;
        if (Objects.equals(this.commentCount, newValue)) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.author, this.committer, this.message, this.tree, newValue);
    }

    public final ImmutableCommit withCommentCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.commentCount, value)) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.author, this.committer, this.message, this.tree, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommit && this.equalTo((ImmutableCommit)another);
    }

    private boolean equalTo(ImmutableCommit another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.author, another.author) && Objects.equals(this.committer, another.committer) && Objects.equals(this.message, another.message) && Objects.equals(this.tree, another.tree) && Objects.equals(this.commentCount, another.commentCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + Objects.hashCode(this.committer);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.tree);
        h += (h << 5) + Objects.hashCode(this.commentCount);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Commit{");
        if (this.sha != null) {
            builder.append("sha=").append(this.sha);
        }
        if (this.url != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.author != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("author=").append(this.author);
        }
        if (this.committer != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("committer=").append(this.committer);
        }
        if (this.message != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("message=").append(this.message);
        }
        if (this.tree != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("tree=").append(this.tree);
        }
        if (this.commentCount != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("commentCount=").append(this.commentCount);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommit fromJson(Json json) {
        Builder builder = ImmutableCommit.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.committer != null) {
            builder.committer(json.committer);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.tree != null) {
            builder.tree(json.tree);
        }
        if (json.commentCount != null) {
            builder.commentCount(json.commentCount);
        }
        return builder.build();
    }

    public static ImmutableCommit copyOf(Commit instance) {
        if (instance instanceof ImmutableCommit) {
            return (ImmutableCommit)instance;
        }
        return ImmutableCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Commit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private Author author;
        @Nullable
        private Author committer;
        @Nullable
        private String message;
        @Nullable
        private ShaLink tree;
        @Nullable
        private Integer commentCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Commit instance) {
            Optional<Integer> commentCountOptional;
            ShaLink treeValue;
            String messageValue;
            Author committerValue;
            Author authorValue;
            URI urlValue;
            Objects.requireNonNull(instance, "instance");
            Optional<String> shaOptional = instance.sha();
            if (shaOptional.isPresent()) {
                this.sha(shaOptional);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            if ((authorValue = instance.author()) != null) {
                this.author(authorValue);
            }
            if ((committerValue = instance.committer()) != null) {
                this.committer(committerValue);
            }
            if ((messageValue = instance.message()) != null) {
                this.message(messageValue);
            }
            if ((treeValue = instance.tree()) != null) {
                this.tree(treeValue);
            }
            if ((commentCountOptional = instance.commentCount()).isPresent()) {
                this.commentCount(commentCountOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sha(String sha) {
            this.sha = Objects.requireNonNull(sha, "sha");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(Optional<String> sha) {
            this.sha = sha.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder author(@Nullable Author author) {
            this.author = author;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder committer(@Nullable Author committer) {
            this.committer = committer;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder tree(@Nullable ShaLink tree) {
            this.tree = tree;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commentCount(int commentCount) {
            this.commentCount = commentCount;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commentCount(Optional<Integer> commentCount) {
            this.commentCount = commentCount.orElse(null);
            return this;
        }

        public ImmutableCommit build() {
            return new ImmutableCommit(this.sha, this.url, this.author, this.committer, this.message, this.tree, this.commentCount);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Commit", generator="Immutables")
    static final class Json
    implements Commit {
        @Nullable
        Optional<String> sha = Optional.empty();
        @Nullable
        URI url;
        @Nullable
        Author author;
        @Nullable
        Author committer;
        @Nullable
        String message;
        @Nullable
        ShaLink tree;
        @Nullable
        Optional<Integer> commentCount = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setSha(Optional<String> sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setAuthor(@Nullable Author author) {
            this.author = author;
        }

        @JsonProperty
        public void setCommitter(@Nullable Author committer) {
            this.committer = committer;
        }

        @JsonProperty
        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        @JsonProperty
        public void setTree(@Nullable ShaLink tree) {
            this.tree = tree;
        }

        @JsonProperty
        public void setCommentCount(Optional<Integer> commentCount) {
            this.commentCount = commentCount;
        }

        @Override
        public Optional<String> sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Author author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Author committer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ShaLink tree() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> commentCount() {
            throw new UnsupportedOperationException();
        }
    }
}

