/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.hooks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.hooks.Webhook;
import com.spotify.github.v3.hooks.WebhookConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Webhook", generator="Immutables")
@Immutable
public final class ImmutableWebhook
implements Webhook {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final Integer id;
    @Nullable
    private final URI url;
    @Nullable
    private final URI testUrl;
    @Nullable
    private final URI pingUrl;
    @Nullable
    private final String name;
    @Nullable
    private final List<String> events;
    @Nullable
    private final Boolean active;
    @Nullable
    private final WebhookConfig config;

    private ImmutableWebhook(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable Integer id, @Nullable URI url, @Nullable URI testUrl, @Nullable URI pingUrl, @Nullable String name, @Nullable List<String> events, @Nullable Boolean active, @Nullable WebhookConfig config) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.id = id;
        this.url = url;
        this.testUrl = testUrl;
        this.pingUrl = pingUrl;
        this.name = name;
        this.events = events;
        this.active = active;
        this.config = config;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI testUrl() {
        return this.testUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI pingUrl() {
        return this.pingUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<String> events() {
        return this.events;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean active() {
        return this.active;
    }

    @Override
    @JsonProperty
    @Nullable
    public WebhookConfig config() {
        return this.config;
    }

    public final ImmutableWebhook withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableWebhook(value, this.updatedAt, this.id, this.url, this.testUrl, this.pingUrl, this.name, this.events, this.active, this.config);
    }

    public final ImmutableWebhook withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableWebhook(this.createdAt, value, this.id, this.url, this.testUrl, this.pingUrl, this.name, this.events, this.active, this.config);
    }

    public final ImmutableWebhook withId(@Nullable Integer value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableWebhook(this.createdAt, this.updatedAt, value, this.url, this.testUrl, this.pingUrl, this.name, this.events, this.active, this.config);
    }

    public final ImmutableWebhook withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, value, this.testUrl, this.pingUrl, this.name, this.events, this.active, this.config);
    }

    public final ImmutableWebhook withTestUrl(@Nullable URI value) {
        if (this.testUrl == value) {
            return this;
        }
        return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, value, this.pingUrl, this.name, this.events, this.active, this.config);
    }

    public final ImmutableWebhook withPingUrl(@Nullable URI value) {
        if (this.pingUrl == value) {
            return this;
        }
        return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, this.testUrl, value, this.name, this.events, this.active, this.config);
    }

    public final ImmutableWebhook withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, this.testUrl, this.pingUrl, value, this.events, this.active, this.config);
    }

    public final ImmutableWebhook withEvents(String ... elements) {
        if (elements == null) {
            return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, this.testUrl, this.pingUrl, this.name, null, this.active, this.config);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableWebhook.createUnmodifiableList(false, ImmutableWebhook.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, this.testUrl, this.pingUrl, this.name, newValue, this.active, this.config);
    }

    public final ImmutableWebhook withEvents(@Nullable Iterable<String> elements) {
        if (this.events == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableWebhook.createUnmodifiableList(false, ImmutableWebhook.createSafeList(elements, true, false));
        return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, this.testUrl, this.pingUrl, this.name, newValue, this.active, this.config);
    }

    public final ImmutableWebhook withActive(@Nullable Boolean value) {
        if (Objects.equals(this.active, value)) {
            return this;
        }
        return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, this.testUrl, this.pingUrl, this.name, this.events, value, this.config);
    }

    public final ImmutableWebhook withConfig(@Nullable WebhookConfig value) {
        if (this.config == value) {
            return this;
        }
        return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, this.testUrl, this.pingUrl, this.name, this.events, this.active, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhook && this.equalTo((ImmutableWebhook)another);
    }

    private boolean equalTo(ImmutableWebhook another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.id, another.id) && Objects.equals(this.url, another.url) && Objects.equals(this.testUrl, another.testUrl) && Objects.equals(this.pingUrl, another.pingUrl) && Objects.equals(this.name, another.name) && Objects.equals(this.events, another.events) && Objects.equals(this.active, another.active) && Objects.equals(this.config, another.config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.testUrl);
        h += (h << 5) + Objects.hashCode(this.pingUrl);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.events);
        h += (h << 5) + Objects.hashCode(this.active);
        h += (h << 5) + Objects.hashCode(this.config);
        return h;
    }

    public String toString() {
        return "Webhook{createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", id=" + this.id + ", url=" + this.url + ", testUrl=" + this.testUrl + ", pingUrl=" + this.pingUrl + ", name=" + this.name + ", events=" + this.events + ", active=" + this.active + ", config=" + this.config + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhook fromJson(Json json) {
        Builder builder = ImmutableWebhook.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.testUrl != null) {
            builder.testUrl(json.testUrl);
        }
        if (json.pingUrl != null) {
            builder.pingUrl(json.pingUrl);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.events != null) {
            builder.addAllEvents(json.events);
        }
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        return builder.build();
    }

    public static ImmutableWebhook copyOf(Webhook instance) {
        if (instance instanceof ImmutableWebhook) {
            return (ImmutableWebhook)instance;
        }
        return ImmutableWebhook.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Webhook", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private Integer id;
        @Nullable
        private URI url;
        @Nullable
        private URI testUrl;
        @Nullable
        private URI pingUrl;
        @Nullable
        private String name;
        private List<String> events = null;
        @Nullable
        private Boolean active;
        @Nullable
        private WebhookConfig config;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Webhook instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdateTracking instance;
            if (object instanceof Webhook) {
                List<String> eventsValue;
                URI urlValue;
                WebhookConfig configValue;
                URI testUrlValue;
                Integer idValue;
                Boolean activeValue;
                URI pingUrlValue;
                instance = (Webhook)object;
                String nameValue = instance.name();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                if ((pingUrlValue = instance.pingUrl()) != null) {
                    this.pingUrl(pingUrlValue);
                }
                if ((activeValue = instance.active()) != null) {
                    this.active(activeValue);
                }
                if ((idValue = instance.id()) != null) {
                    this.id(idValue);
                }
                if ((testUrlValue = instance.testUrl()) != null) {
                    this.testUrl(testUrlValue);
                }
                if ((configValue = instance.config()) != null) {
                    this.config(configValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                if ((eventsValue = instance.events()) != null) {
                    this.addAllEvents(eventsValue);
                }
            }
            if (object instanceof UpdateTracking) {
                GitHubInstant updatedAtValue;
                instance = (UpdateTracking)object;
                GitHubInstant createdAtValue = instance.createdAt();
                if (createdAtValue != null) {
                    this.createdAt(createdAtValue);
                }
                if ((updatedAtValue = instance.updatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder testUrl(@Nullable URI testUrl) {
            this.testUrl = testUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pingUrl(@Nullable URI pingUrl) {
            this.pingUrl = pingUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String element) {
            if (this.events == null) {
                this.events = new ArrayList<String>();
            }
            this.events.add(Objects.requireNonNull(element, "events element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String ... elements) {
            if (this.events == null) {
                this.events = new ArrayList<String>();
            }
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder events(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.events = null;
                return this;
            }
            this.events = new ArrayList<String>();
            return this.addAllEvents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEvents(Iterable<String> elements) {
            Objects.requireNonNull(elements, "events element");
            if (this.events == null) {
                this.events = new ArrayList<String>();
            }
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder config(@Nullable WebhookConfig config) {
            this.config = config;
            return this;
        }

        public ImmutableWebhook build() {
            return new ImmutableWebhook(this.createdAt, this.updatedAt, this.id, this.url, this.testUrl, this.pingUrl, this.name, this.events == null ? null : ImmutableWebhook.createUnmodifiableList(true, this.events), this.active, this.config);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Webhook", generator="Immutables")
    static final class Json
    implements Webhook {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        Integer id;
        @Nullable
        URI url;
        @Nullable
        URI testUrl;
        @Nullable
        URI pingUrl;
        @Nullable
        String name;
        @Nullable
        List<String> events = null;
        @Nullable
        Boolean active;
        @Nullable
        WebhookConfig config;

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setId(@Nullable Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setTestUrl(@Nullable URI testUrl) {
            this.testUrl = testUrl;
        }

        @JsonProperty
        public void setPingUrl(@Nullable URI pingUrl) {
            this.pingUrl = pingUrl;
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setEvents(@Nullable List<String> events) {
            this.events = events;
        }

        @JsonProperty
        public void setActive(@Nullable Boolean active) {
            this.active = active;
        }

        @JsonProperty
        public void setConfig(@Nullable WebhookConfig config) {
            this.config = config;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI testUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI pingUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> events() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean active() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WebhookConfig config() {
            throw new UnsupportedOperationException();
        }
    }
}

