/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.orgs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.orgs.requests.TeamCreate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TeamCreate", generator="Immutables")
@Immutable
public final class ImmutableTeamCreate
implements TeamCreate {
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String maintainers;
    @Nullable
    private final String repo_names;
    @Nullable
    private final String parent_team_id;

    private ImmutableTeamCreate(@Nullable String name, @Nullable String description, @Nullable String maintainers, @Nullable String repo_names, @Nullable String parent_team_id) {
        this.name = name;
        this.description = description;
        this.maintainers = maintainers;
        this.repo_names = repo_names;
        this.parent_team_id = parent_team_id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    public Optional<String> maintainers() {
        return Optional.ofNullable(this.maintainers);
    }

    @Override
    @JsonProperty
    public Optional<String> repo_names() {
        return Optional.ofNullable(this.repo_names);
    }

    @Override
    @JsonProperty
    public Optional<String> parent_team_id() {
        return Optional.ofNullable(this.parent_team_id);
    }

    public final ImmutableTeamCreate withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableTeamCreate(value, this.description, this.maintainers, this.repo_names, this.parent_team_id);
    }

    public final ImmutableTeamCreate withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, newValue, this.maintainers, this.repo_names, this.parent_team_id);
    }

    public final ImmutableTeamCreate withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, value, this.maintainers, this.repo_names, this.parent_team_id);
    }

    public final ImmutableTeamCreate withMaintainers(String value) {
        String newValue = Objects.requireNonNull(value, "maintainers");
        if (Objects.equals(this.maintainers, newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, newValue, this.repo_names, this.parent_team_id);
    }

    public final ImmutableTeamCreate withMaintainers(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.maintainers, value)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, value, this.repo_names, this.parent_team_id);
    }

    public final ImmutableTeamCreate withRepo_names(String value) {
        String newValue = Objects.requireNonNull(value, "repo_names");
        if (Objects.equals(this.repo_names, newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.maintainers, newValue, this.parent_team_id);
    }

    public final ImmutableTeamCreate withRepo_names(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.repo_names, value)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.maintainers, value, this.parent_team_id);
    }

    public final ImmutableTeamCreate withParent_team_id(String value) {
        String newValue = Objects.requireNonNull(value, "parent_team_id");
        if (Objects.equals(this.parent_team_id, newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.maintainers, this.repo_names, newValue);
    }

    public final ImmutableTeamCreate withParent_team_id(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.parent_team_id, value)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.maintainers, this.repo_names, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTeamCreate && this.equalTo((ImmutableTeamCreate)another);
    }

    private boolean equalTo(ImmutableTeamCreate another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.maintainers, another.maintainers) && Objects.equals(this.repo_names, another.repo_names) && Objects.equals(this.parent_team_id, another.parent_team_id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.maintainers);
        h += (h << 5) + Objects.hashCode(this.repo_names);
        h += (h << 5) + Objects.hashCode(this.parent_team_id);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TeamCreate{");
        if (this.name != null) {
            builder.append("name=").append(this.name);
        }
        if (this.description != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("description=").append(this.description);
        }
        if (this.maintainers != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("maintainers=").append(this.maintainers);
        }
        if (this.repo_names != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("repo_names=").append(this.repo_names);
        }
        if (this.parent_team_id != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("parent_team_id=").append(this.parent_team_id);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTeamCreate fromJson(Json json) {
        Builder builder = ImmutableTeamCreate.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.maintainers != null) {
            builder.maintainers(json.maintainers);
        }
        if (json.repo_names != null) {
            builder.repo_names(json.repo_names);
        }
        if (json.parent_team_id != null) {
            builder.parent_team_id(json.parent_team_id);
        }
        return builder.build();
    }

    public static ImmutableTeamCreate copyOf(TeamCreate instance) {
        if (instance instanceof ImmutableTeamCreate) {
            return (ImmutableTeamCreate)instance;
        }
        return ImmutableTeamCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TeamCreate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String maintainers;
        @Nullable
        private String repo_names;
        @Nullable
        private String parent_team_id;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TeamCreate instance) {
            Optional<String> parent_team_idOptional;
            Optional<String> repo_namesOptional;
            Optional<String> maintainersOptional;
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((descriptionOptional = instance.description()).isPresent()) {
                this.description(descriptionOptional);
            }
            if ((maintainersOptional = instance.maintainers()).isPresent()) {
                this.maintainers(maintainersOptional);
            }
            if ((repo_namesOptional = instance.repo_names()).isPresent()) {
                this.repo_names(repo_namesOptional);
            }
            if ((parent_team_idOptional = instance.parent_team_id()).isPresent()) {
                this.parent_team_id(parent_team_idOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maintainers(String maintainers) {
            this.maintainers = Objects.requireNonNull(maintainers, "maintainers");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder maintainers(Optional<String> maintainers) {
            this.maintainers = maintainers.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo_names(String repo_names) {
            this.repo_names = Objects.requireNonNull(repo_names, "repo_names");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repo_names(Optional<String> repo_names) {
            this.repo_names = repo_names.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parent_team_id(String parent_team_id) {
            this.parent_team_id = Objects.requireNonNull(parent_team_id, "parent_team_id");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder parent_team_id(Optional<String> parent_team_id) {
            this.parent_team_id = parent_team_id.orElse(null);
            return this;
        }

        public ImmutableTeamCreate build() {
            return new ImmutableTeamCreate(this.name, this.description, this.maintainers, this.repo_names, this.parent_team_id);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TeamCreate", generator="Immutables")
    static final class Json
    implements TeamCreate {
        @Nullable
        String name;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<String> maintainers = Optional.empty();
        @Nullable
        Optional<String> repo_names = Optional.empty();
        @Nullable
        Optional<String> parent_team_id = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setMaintainers(Optional<String> maintainers) {
            this.maintainers = maintainers;
        }

        @JsonProperty
        public void setRepo_names(Optional<String> repo_names) {
            this.repo_names = repo_names;
        }

        @JsonProperty
        public void setParent_team_id(Optional<String> parent_team_id) {
            this.parent_team_id = parent_team_id;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> maintainers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> repo_names() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> parent_team_id() {
            throw new UnsupportedOperationException();
        }
    }
}

