/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class BranchProtectionUrlDeserializer
extends JsonDeserializer<Optional<URI>> {
    private URI fixInvalidGithubUrl(String invalidUrl) {
        String[] schemaAndPath = invalidUrl.split("//");
        CharSequence[] pathParts = schemaAndPath[1].split("/");
        for (int i = 0; i < pathParts.length; ++i) {
            pathParts[i] = URLEncoder.encode(pathParts[i], StandardCharsets.UTF_8);
        }
        String fixedUrlString = schemaAndPath[0] + "//" + String.join((CharSequence)"/", pathParts);
        return URI.create(fixedUrlString);
    }

    public Optional<URI> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        TypeReference<Optional<String>> ref = new TypeReference<Optional<String>>(){};
        Optional protectionUrlStringOpt = (Optional)jsonParser.readValueAs((TypeReference)ref);
        return protectionUrlStringOpt.map(protectionUrlString -> {
            try {
                return new URI((String)protectionUrlString);
            }
            catch (URISyntaxException e) {
                return this.fixInvalidGithubUrl((String)protectionUrlString);
            }
        });
    }
}

