/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.git.ShaLink;
import com.spotify.github.v3.repos.Commit;
import com.spotify.github.v3.repos.CommitItem;
import com.spotify.github.v3.repos.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Commit", generator="Immutables")
@Immutable
public final class ImmutableCommit
implements Commit {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final com.spotify.github.v3.git.Commit commit;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI commentsUrl;
    @Nullable
    private final User author;
    @Nullable
    private final List<ShaLink> parents;
    @Nullable
    private final Map<String, Integer> stats;
    @Nullable
    private final List<File> files;
    @Nullable
    private final ShaLink tree;

    private ImmutableCommit(@Nullable String sha, @Nullable URI url, @Nullable com.spotify.github.v3.git.Commit commit, @Nullable URI htmlUrl, @Nullable URI commentsUrl, @Nullable User author, @Nullable List<ShaLink> parents, @Nullable Map<String, Integer> stats, @Nullable List<File> files, @Nullable ShaLink tree) {
        this.sha = sha;
        this.url = url;
        this.commit = commit;
        this.htmlUrl = htmlUrl;
        this.commentsUrl = commentsUrl;
        this.author = author;
        this.parents = parents;
        this.stats = stats;
        this.files = files;
        this.tree = tree;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public com.spotify.github.v3.git.Commit commit() {
        return this.commit;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commentsUrl() {
        return this.commentsUrl;
    }

    @Override
    @JsonProperty
    public Optional<User> author() {
        return Optional.ofNullable(this.author);
    }

    @Override
    @JsonProperty
    @Nullable
    public List<ShaLink> parents() {
        return this.parents;
    }

    @Override
    @JsonProperty
    @Nullable
    public Map<String, Integer> stats() {
        return this.stats;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<File> files() {
        return this.files;
    }

    @Override
    @JsonProperty
    @Nullable
    public ShaLink tree() {
        return this.tree;
    }

    public final ImmutableCommit withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableCommit(value, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, value, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withCommit(@Nullable com.spotify.github.v3.git.Commit value) {
        if (this.commit == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, value, this.htmlUrl, this.commentsUrl, this.author, this.parents, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.commit, value, this.commentsUrl, this.author, this.parents, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withCommentsUrl(@Nullable URI value) {
        if (this.commentsUrl == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, value, this.author, this.parents, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withAuthor(User value) {
        User newValue = Objects.requireNonNull(value, "author");
        if (this.author == newValue) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, newValue, this.parents, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withAuthor(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.author == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, value, this.parents, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withParents(ShaLink ... elements) {
        if (elements == null) {
            return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, null, this.stats, this.files, this.tree);
        }
        List<ShaLink> newValue = Arrays.asList(elements) == null ? null : ImmutableCommit.createUnmodifiableList(false, ImmutableCommit.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, newValue, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withParents(@Nullable Iterable<? extends ShaLink> elements) {
        if (this.parents == elements) {
            return this;
        }
        List<ShaLink> newValue = elements == null ? null : ImmutableCommit.createUnmodifiableList(false, ImmutableCommit.createSafeList(elements, true, false));
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, newValue, this.stats, this.files, this.tree);
    }

    public final ImmutableCommit withStats(@Nullable Map<String, ? extends Integer> entries) {
        if (this.stats == entries) {
            return this;
        }
        Map<String, Integer> newValue = entries == null ? null : ImmutableCommit.createUnmodifiableMap(true, false, entries);
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents, newValue, this.files, this.tree);
    }

    public final ImmutableCommit withFiles(File ... elements) {
        if (elements == null) {
            return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents, this.stats, null, this.tree);
        }
        List<File> newValue = Arrays.asList(elements) == null ? null : ImmutableCommit.createUnmodifiableList(false, ImmutableCommit.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents, this.stats, newValue, this.tree);
    }

    public final ImmutableCommit withFiles(@Nullable Iterable<? extends File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<File> newValue = elements == null ? null : ImmutableCommit.createUnmodifiableList(false, ImmutableCommit.createSafeList(elements, true, false));
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents, this.stats, newValue, this.tree);
    }

    public final ImmutableCommit withTree(@Nullable ShaLink value) {
        if (this.tree == value) {
            return this;
        }
        return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents, this.stats, this.files, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommit && this.equalTo((ImmutableCommit)another);
    }

    private boolean equalTo(ImmutableCommit another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.commit, another.commit) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.commentsUrl, another.commentsUrl) && Objects.equals(this.author, another.author) && Objects.equals(this.parents, another.parents) && Objects.equals(this.stats, another.stats) && Objects.equals(this.files, another.files) && Objects.equals(this.tree, another.tree);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.commit);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.commentsUrl);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + Objects.hashCode(this.parents);
        h += (h << 5) + Objects.hashCode(this.stats);
        h += (h << 5) + Objects.hashCode(this.files);
        h += (h << 5) + Objects.hashCode(this.tree);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Commit{");
        if (this.sha != null) {
            builder.append("sha=").append(this.sha);
        }
        if (this.url != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.commit != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("commit=").append(this.commit);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (this.commentsUrl != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("commentsUrl=").append(this.commentsUrl);
        }
        if (this.author != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("author=").append(this.author);
        }
        if (this.parents != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("parents=").append(this.parents);
        }
        if (this.stats != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("stats=").append(this.stats);
        }
        if (this.files != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("files=").append(this.files);
        }
        if (this.tree != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("tree=").append(this.tree);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommit fromJson(Json json) {
        Builder builder = ImmutableCommit.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.commit != null) {
            builder.commit(json.commit);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.commentsUrl != null) {
            builder.commentsUrl(json.commentsUrl);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.parents != null) {
            builder.addAllParents(json.parents);
        }
        if (json.stats != null) {
            builder.putAllStats(json.stats);
        }
        if (json.files != null) {
            builder.addAllFiles(json.files);
        }
        if (json.tree != null) {
            builder.tree(json.tree);
        }
        return builder.build();
    }

    public static ImmutableCommit copyOf(Commit instance) {
        if (instance instanceof ImmutableCommit) {
            return (ImmutableCommit)instance;
        }
        return ImmutableCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Commit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private com.spotify.github.v3.git.Commit commit;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI commentsUrl;
        @Nullable
        private User author;
        private List<ShaLink> parents = null;
        private Map<String, Integer> stats = null;
        private List<File> files = null;
        @Nullable
        private ShaLink tree;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Commit instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ShaLink instance;
            if (object instanceof Commit) {
                List<File> filesValue;
                Map<String, Integer> statsValue;
                instance = (Commit)object;
                ShaLink treeValue = instance.tree();
                if (treeValue != null) {
                    this.tree(treeValue);
                }
                if ((statsValue = instance.stats()) != null) {
                    this.putAllStats(statsValue);
                }
                if ((filesValue = instance.files()) != null) {
                    this.addAllFiles(filesValue);
                }
            }
            if (object instanceof ShaLink) {
                URI urlValue;
                instance = (ShaLink)object;
                String shaValue = instance.sha();
                if (shaValue != null) {
                    this.sha(shaValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
            }
            if (object instanceof CommitItem) {
                List<ShaLink> parentsValue;
                Optional<User> authorOptional;
                URI commentsUrlValue;
                URI htmlUrlValue;
                instance = (CommitItem)object;
                com.spotify.github.v3.git.Commit commitValue = instance.commit();
                if (commitValue != null) {
                    this.commit(commitValue);
                }
                if ((htmlUrlValue = instance.htmlUrl()) != null) {
                    this.htmlUrl(htmlUrlValue);
                }
                if ((commentsUrlValue = instance.commentsUrl()) != null) {
                    this.commentsUrl(commentsUrlValue);
                }
                if ((authorOptional = instance.author()).isPresent()) {
                    this.author(authorOptional);
                }
                if ((parentsValue = instance.parents()) != null) {
                    this.addAllParents(parentsValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commit(@Nullable com.spotify.github.v3.git.Commit commit) {
            this.commit = commit;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder author(User author) {
            this.author = Objects.requireNonNull(author, "author");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder author(Optional<? extends User> author) {
            this.author = author.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(ShaLink element) {
            if (this.parents == null) {
                this.parents = new ArrayList<ShaLink>();
            }
            this.parents.add(Objects.requireNonNull(element, "parents element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(ShaLink ... elements) {
            if (this.parents == null) {
                this.parents = new ArrayList<ShaLink>();
            }
            for (ShaLink element : elements) {
                this.parents.add(Objects.requireNonNull(element, "parents element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder parents(@Nullable Iterable<? extends ShaLink> elements) {
            if (elements == null) {
                this.parents = null;
                return this;
            }
            this.parents = new ArrayList<ShaLink>();
            return this.addAllParents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParents(Iterable<? extends ShaLink> elements) {
            Objects.requireNonNull(elements, "parents element");
            if (this.parents == null) {
                this.parents = new ArrayList<ShaLink>();
            }
            for (ShaLink shaLink : elements) {
                this.parents.add(Objects.requireNonNull(shaLink, "parents element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putStats(String key, int value) {
            if (this.stats == null) {
                this.stats = new LinkedHashMap<String, Integer>();
            }
            this.stats.put(Objects.requireNonNull(key, "stats key"), Objects.requireNonNull(Integer.valueOf(value), "stats value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putStats(Map.Entry<String, ? extends Integer> entry) {
            if (this.stats == null) {
                this.stats = new LinkedHashMap<String, Integer>();
            }
            String k = entry.getKey();
            Integer v = entry.getValue();
            this.stats.put(Objects.requireNonNull(k, "stats key"), Objects.requireNonNull(v, "stats value"));
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder stats(@Nullable Map<String, ? extends Integer> entries) {
            if (entries == null) {
                this.stats = null;
                return this;
            }
            this.stats = new LinkedHashMap<String, Integer>();
            return this.putAllStats(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllStats(Map<String, ? extends Integer> entries) {
            if (this.stats == null) {
                this.stats = new LinkedHashMap<String, Integer>();
            }
            for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
                String k = e.getKey();
                Integer v = e.getValue();
                this.stats.put(Objects.requireNonNull(k, "stats key"), Objects.requireNonNull(v, "stats value"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFiles(File element) {
            if (this.files == null) {
                this.files = new ArrayList<File>();
            }
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFiles(File ... elements) {
            if (this.files == null) {
                this.files = new ArrayList<File>();
            }
            for (File element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder files(@Nullable Iterable<? extends File> elements) {
            if (elements == null) {
                this.files = null;
                return this;
            }
            this.files = new ArrayList<File>();
            return this.addAllFiles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFiles(Iterable<? extends File> elements) {
            Objects.requireNonNull(elements, "files element");
            if (this.files == null) {
                this.files = new ArrayList<File>();
            }
            for (File file : elements) {
                this.files.add(Objects.requireNonNull(file, "files element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder tree(@Nullable ShaLink tree) {
            this.tree = tree;
            return this;
        }

        public ImmutableCommit build() {
            return new ImmutableCommit(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents == null ? null : ImmutableCommit.createUnmodifiableList(true, this.parents), this.stats == null ? null : ImmutableCommit.createUnmodifiableMap(false, false, this.stats), this.files == null ? null : ImmutableCommit.createUnmodifiableList(true, this.files), this.tree);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Commit", generator="Immutables")
    static final class Json
    implements Commit {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        com.spotify.github.v3.git.Commit commit;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI commentsUrl;
        @Nullable
        Optional<User> author = Optional.empty();
        @Nullable
        List<ShaLink> parents = null;
        @Nullable
        Map<String, Integer> stats = null;
        @Nullable
        List<File> files = null;
        @Nullable
        ShaLink tree;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setCommit(@Nullable com.spotify.github.v3.git.Commit commit) {
            this.commit = commit;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setCommentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
        }

        @JsonProperty
        public void setAuthor(Optional<User> author) {
            this.author = author;
        }

        @JsonProperty
        public void setParents(@Nullable List<ShaLink> parents) {
            this.parents = parents;
        }

        @JsonProperty
        public void setStats(@Nullable Map<String, Integer> stats) {
            this.stats = stats;
        }

        @JsonProperty
        public void setFiles(@Nullable List<File> files) {
            this.files = files;
        }

        @JsonProperty
        public void setTree(@Nullable ShaLink tree) {
            this.tree = tree;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public com.spotify.github.v3.git.Commit commit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ShaLink> parents() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Integer> stats() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<File> files() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ShaLink tree() {
            throw new UnsupportedOperationException();
        }
    }
}

