/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Deployment;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Deployment", generator="Immutables")
@Immutable
public final class ImmutableDeployment
implements Deployment {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final URI url;
    @Nullable
    private final Long id;
    @Nullable
    private final String sha;
    @Nullable
    private final String ref;
    @Nullable
    private final String task;
    @Nullable
    private final Map<String, String> payload;
    @Nullable
    private final String environment;
    @Nullable
    private final String description;
    @Nullable
    private final User creator;
    @Nullable
    private final URI statusesUrl;
    @Nullable
    private final URI repositoryUrl;

    private ImmutableDeployment(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable URI url, @Nullable Long id, @Nullable String sha, @Nullable String ref, @Nullable String task, @Nullable Map<String, String> payload, @Nullable String environment, @Nullable String description, @Nullable User creator, @Nullable URI statusesUrl, @Nullable URI repositoryUrl) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.id = id;
        this.sha = sha;
        this.ref = ref;
        this.task = task;
        this.payload = payload;
        this.environment = environment;
        this.description = description;
        this.creator = creator;
        this.statusesUrl = statusesUrl;
        this.repositoryUrl = repositoryUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public String ref() {
        return this.ref;
    }

    @Override
    @JsonProperty
    @Nullable
    public String task() {
        return this.task;
    }

    @Override
    @JsonProperty
    public Optional<Map<String, String>> payload() {
        return Optional.ofNullable(this.payload);
    }

    @Override
    @JsonProperty
    @Nullable
    public String environment() {
        return this.environment;
    }

    @Override
    @JsonProperty
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    @Nullable
    public User creator() {
        return this.creator;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI statusesUrl() {
        return this.statusesUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI repositoryUrl() {
        return this.repositoryUrl;
    }

    public final ImmutableDeployment withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableDeployment(value, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, this.payload, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, value, this.url, this.id, this.sha, this.ref, this.task, this.payload, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, value, this.id, this.sha, this.ref, this.task, this.payload, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withId(@Nullable Long value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, value, this.sha, this.ref, this.task, this.payload, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, value, this.ref, this.task, this.payload, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, value, this.task, this.payload, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withTask(@Nullable String value) {
        if (Objects.equals(this.task, value)) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, value, this.payload, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withPayload(Map<String, String> value) {
        Map<String, String> newValue = Objects.requireNonNull(value, "payload");
        if (this.payload == newValue) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, newValue, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withPayload(Optional<? extends Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.payload == value) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, value, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withEnvironment(@Nullable String value) {
        if (Objects.equals(this.environment, value)) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, this.payload, value, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, this.payload, this.environment, newValue, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, this.payload, this.environment, value, this.creator, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withCreator(@Nullable User value) {
        if (this.creator == value) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, this.payload, this.environment, this.description, value, this.statusesUrl, this.repositoryUrl);
    }

    public final ImmutableDeployment withStatusesUrl(@Nullable URI value) {
        if (this.statusesUrl == value) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, this.payload, this.environment, this.description, this.creator, value, this.repositoryUrl);
    }

    public final ImmutableDeployment withRepositoryUrl(@Nullable URI value) {
        if (this.repositoryUrl == value) {
            return this;
        }
        return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, this.payload, this.environment, this.description, this.creator, this.statusesUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeployment && this.equalTo((ImmutableDeployment)another);
    }

    private boolean equalTo(ImmutableDeployment another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.url, another.url) && Objects.equals(this.id, another.id) && Objects.equals(this.sha, another.sha) && Objects.equals(this.ref, another.ref) && Objects.equals(this.task, another.task) && Objects.equals(this.payload, another.payload) && Objects.equals(this.environment, another.environment) && Objects.equals(this.description, another.description) && Objects.equals(this.creator, another.creator) && Objects.equals(this.statusesUrl, another.statusesUrl) && Objects.equals(this.repositoryUrl, another.repositoryUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.task);
        h += (h << 5) + Objects.hashCode(this.payload);
        h += (h << 5) + Objects.hashCode(this.environment);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.creator);
        h += (h << 5) + Objects.hashCode(this.statusesUrl);
        h += (h << 5) + Objects.hashCode(this.repositoryUrl);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Deployment{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.url != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.id != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        if (this.sha != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("sha=").append(this.sha);
        }
        if (this.ref != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("ref=").append(this.ref);
        }
        if (this.task != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("task=").append(this.task);
        }
        if (this.payload != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("payload=").append(this.payload);
        }
        if (this.environment != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("environment=").append(this.environment);
        }
        if (this.description != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("description=").append(this.description);
        }
        if (this.creator != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("creator=").append(this.creator);
        }
        if (this.statusesUrl != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("statusesUrl=").append(this.statusesUrl);
        }
        if (this.repositoryUrl != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("repositoryUrl=").append(this.repositoryUrl);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeployment fromJson(Json json) {
        Builder builder = ImmutableDeployment.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.ref != null) {
            builder.ref(json.ref);
        }
        if (json.task != null) {
            builder.task(json.task);
        }
        if (json.payload != null) {
            builder.payload(json.payload);
        }
        if (json.environment != null) {
            builder.environment(json.environment);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.creator != null) {
            builder.creator(json.creator);
        }
        if (json.statusesUrl != null) {
            builder.statusesUrl(json.statusesUrl);
        }
        if (json.repositoryUrl != null) {
            builder.repositoryUrl(json.repositoryUrl);
        }
        return builder.build();
    }

    public static ImmutableDeployment copyOf(Deployment instance) {
        if (instance instanceof ImmutableDeployment) {
            return (ImmutableDeployment)instance;
        }
        return ImmutableDeployment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Deployment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private URI url;
        @Nullable
        private Long id;
        @Nullable
        private String sha;
        @Nullable
        private String ref;
        @Nullable
        private String task;
        @Nullable
        private Map<String, String> payload;
        @Nullable
        private String environment;
        @Nullable
        private String description;
        @Nullable
        private User creator;
        @Nullable
        private URI statusesUrl;
        @Nullable
        private URI repositoryUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Deployment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdateTracking instance;
            if (object instanceof Deployment) {
                URI repositoryUrlValue;
                URI urlValue;
                String shaValue;
                Long idValue;
                URI statusesUrlValue;
                Optional<String> descriptionOptional;
                Optional<Map<String, String>> payloadOptional;
                String taskValue;
                String environmentValue;
                String refValue;
                instance = (Deployment)object;
                User creatorValue = instance.creator();
                if (creatorValue != null) {
                    this.creator(creatorValue);
                }
                if ((refValue = instance.ref()) != null) {
                    this.ref(refValue);
                }
                if ((environmentValue = instance.environment()) != null) {
                    this.environment(environmentValue);
                }
                if ((taskValue = instance.task()) != null) {
                    this.task(taskValue);
                }
                if ((payloadOptional = instance.payload()).isPresent()) {
                    this.payload(payloadOptional);
                }
                if ((descriptionOptional = instance.description()).isPresent()) {
                    this.description(descriptionOptional);
                }
                if ((statusesUrlValue = instance.statusesUrl()) != null) {
                    this.statusesUrl(statusesUrlValue);
                }
                if ((idValue = instance.id()) != null) {
                    this.id(idValue);
                }
                if ((shaValue = instance.sha()) != null) {
                    this.sha(shaValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                if ((repositoryUrlValue = instance.repositoryUrl()) != null) {
                    this.repositoryUrl(repositoryUrlValue);
                }
            }
            if (object instanceof UpdateTracking) {
                GitHubInstant updatedAtValue;
                instance = (UpdateTracking)object;
                GitHubInstant createdAtValue = instance.createdAt();
                if (createdAtValue != null) {
                    this.createdAt(createdAtValue);
                }
                if ((updatedAtValue = instance.updatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Long id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder task(@Nullable String task) {
            this.task = task;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(Map<String, String> payload) {
            this.payload = Objects.requireNonNull(payload, "payload");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder payload(Optional<? extends Map<String, String>> payload) {
            this.payload = payload.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder environment(@Nullable String environment) {
            this.environment = environment;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder creator(@Nullable User creator) {
            this.creator = creator;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder statusesUrl(@Nullable URI statusesUrl) {
            this.statusesUrl = statusesUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repositoryUrl(@Nullable URI repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public ImmutableDeployment build() {
            return new ImmutableDeployment(this.createdAt, this.updatedAt, this.url, this.id, this.sha, this.ref, this.task, this.payload, this.environment, this.description, this.creator, this.statusesUrl, this.repositoryUrl);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Deployment", generator="Immutables")
    static final class Json
    implements Deployment {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        URI url;
        @Nullable
        Long id;
        @Nullable
        String sha;
        @Nullable
        String ref;
        @Nullable
        String task;
        @Nullable
        Optional<Map<String, String>> payload = Optional.empty();
        @Nullable
        String environment;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        User creator;
        @Nullable
        URI statusesUrl;
        @Nullable
        URI repositoryUrl;

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setId(@Nullable Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setRef(@Nullable String ref) {
            this.ref = ref;
        }

        @JsonProperty
        public void setTask(@Nullable String task) {
            this.task = task;
        }

        @JsonProperty
        public void setPayload(Optional<Map<String, String>> payload) {
            this.payload = payload;
        }

        @JsonProperty
        public void setEnvironment(@Nullable String environment) {
            this.environment = environment;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setCreator(@Nullable User creator) {
            this.creator = creator;
        }

        @JsonProperty
        public void setStatusesUrl(@Nullable URI statusesUrl) {
            this.statusesUrl = statusesUrl;
        }

        @JsonProperty
        public void setRepositoryUrl(@Nullable URI repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String task() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> payload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String environment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User creator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI statusesUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI repositoryUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

