/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.context;

import com.spotify.helios.common.context.ContextCallable;
import com.spotify.helios.common.context.ContextRunnable;
import java.util.Arrays;

public class CallPathToExecutorException
extends Exception {
    private static final String CONTEXT_RUNNABLE = ContextRunnable.class.getCanonicalName();
    private static final String CONTEXT_CALLABLE = ContextCallable.class.getCanonicalName();

    CallPathToExecutorException(StackTraceElement[] trace) {
        int c = 0;
        for (StackTraceElement element : trace) {
            ++c;
            String className = element.getClassName();
            if (className.equals(CONTEXT_RUNNABLE) || className.equals(CONTEXT_CALLABLE)) break;
        }
        if (c == trace.length) {
            c = 0;
        }
        this.setStackTrace(Arrays.copyOfRange(trace, c, trace.length));
    }
}

