/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.context;

import com.spotify.helios.common.context.Context;
import java.util.concurrent.Callable;

final class ContextCallable<T>
implements Callable<T> {
    private final Callable<T> task;
    private final StackTraceElement[] trace;

    ContextCallable(Callable<T> task) {
        this.task = task;
        this.trace = Context.getStackContext();
    }

    @Override
    public T call() throws Exception {
        try {
            return this.task.call();
        }
        catch (Throwable th) {
            Context.handleException(this.trace, th);
            throw th;
        }
    }
}

