/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.JobId;
import org.jetbrains.annotations.Nullable;

public class Deployment
extends Descriptor {
    public static final String EMTPY_DEPLOYER_USER = null;
    private final JobId jobId;
    private final Goal goal;
    private final String deployerUser;

    public Deployment(@JsonProperty(value="job") JobId jobId, @JsonProperty(value="goal") Goal goal, @JsonProperty(value="deployerUser") @Nullable String deployerUser) {
        this.jobId = jobId;
        this.goal = goal;
        this.deployerUser = deployerUser;
    }

    public static Deployment of(JobId jobId, Goal goal) {
        return Deployment.newBuilder().setJobId(jobId).setGoal(goal).build();
    }

    public static Deployment of(JobId jobId, Goal goal, String deployerUser) {
        return Deployment.newBuilder().setJobId(jobId).setGoal(goal).setDeployerUser(deployerUser).build();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public String getDeployerUser() {
        return this.deployerUser;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("jobId", (Object)this.jobId).add("goal", (Object)this.goal).add("deployerUser", (Object)this.deployerUser).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deployment that = (Deployment)o;
        if (this.goal != that.goal) {
            return false;
        }
        if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
            return false;
        }
        return !(this.deployerUser != null ? !this.deployerUser.equals(that.deployerUser) : that.deployerUser != null);
    }

    public int hashCode() {
        int result = this.jobId != null ? this.jobId.hashCode() : 0;
        result = 31 * result + (this.goal != null ? this.goal.hashCode() : 0);
        result = 31 * result + (this.deployerUser != null ? this.deployerUser.hashCode() : 0);
        return result;
    }

    public Builder toBuilder() {
        return Deployment.newBuilder().setDeployerUser(this.deployerUser).setGoal(this.goal).setJobId(this.jobId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private JobId jobId;
        private Goal goal;
        private String deployerUser;

        public Builder setJobId(JobId jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setGoal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public Builder setDeployerUser(String deployerUser) {
            this.deployerUser = deployerUser;
            return this;
        }

        public Deployment build() {
            return new Deployment(this.jobId, this.goal, this.deployerUser);
        }
    }
}

