/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.spotify.helios.common.descriptors.AgentInfo;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class HostStatus
extends Descriptor {
    private final Status status;
    private final HostInfo hostInfo;
    private final AgentInfo agentInfo;
    private final Map<JobId, Deployment> jobs;
    private final Map<JobId, TaskStatus> statuses;
    private final Map<String, String> environment;

    public HostStatus(@JsonProperty(value="jobs") Map<JobId, Deployment> jobs, @JsonProperty(value="statuses") Map<JobId, TaskStatus> statuses, @JsonProperty(value="status") Status status, @JsonProperty(value="hostInfo") HostInfo hostInfo, @JsonProperty(value="agentInfo") AgentInfo agentInfo, @JsonProperty(value="environment") Map<String, String> environment) {
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.jobs = (Map)Preconditions.checkNotNull(jobs, (Object)"jobs");
        this.statuses = (Map)Preconditions.checkNotNull(statuses, (Object)"statuses");
        this.hostInfo = hostInfo;
        this.agentInfo = agentInfo;
        this.environment = (Map)Optional.fromNullable(environment).or(Collections.emptyMap());
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    @Nullable
    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public Map<JobId, Deployment> getJobs() {
        return this.jobs;
    }

    public Map<JobId, TaskStatus> getStatuses() {
        return this.statuses;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostStatus that = (HostStatus)o;
        if (this.hostInfo != null ? !this.hostInfo.equals(that.hostInfo) : that.hostInfo != null) {
            return false;
        }
        if (this.jobs != null ? !this.jobs.equals(that.jobs) : that.jobs != null) {
            return false;
        }
        if (this.agentInfo != null ? !this.agentInfo.equals(that.agentInfo) : that.agentInfo != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.statuses != null ? !this.statuses.equals(that.statuses) : that.statuses != null) {
            return false;
        }
        return !(this.environment != null ? !this.environment.equals(that.environment) : that.environment != null);
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + (this.hostInfo != null ? this.hostInfo.hashCode() : 0);
        result = 31 * result + (this.agentInfo != null ? this.agentInfo.hashCode() : 0);
        result = 31 * result + (this.jobs != null ? this.jobs.hashCode() : 0);
        result = 31 * result + (this.statuses != null ? this.statuses.hashCode() : 0);
        result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
        return result;
    }

    public String toString() {
        String strEnv = Joiner.on((String)", ").join(Iterables.transform(this.environment.entrySet(), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> entry) {
                return entry.getKey() + "=" + entry.getValue();
            }
        }));
        return "HostStatus{status=" + (Object)((Object)this.status) + ", hostInfo=" + this.hostInfo + ", agentInfo=" + this.agentInfo + ", jobs=" + this.jobs + ", statuses=" + this.statuses + ", environment={" + strEnv + "}" + '}';
    }

    public static class Builder {
        private Map<JobId, Deployment> jobs;
        private Map<JobId, TaskStatus> statuses;
        private Status status;
        private HostInfo hostInfo;
        private AgentInfo agentInfo;
        private Map<String, String> environment;

        public Builder setJobs(Map<JobId, Deployment> jobs) {
            this.jobs = jobs;
            return this;
        }

        public Builder setStatuses(Map<JobId, TaskStatus> statuses) {
            this.statuses = statuses;
            return this;
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder setHostInfo(HostInfo hostInfo) {
            this.hostInfo = hostInfo;
            return this;
        }

        public Builder setAgentInfo(AgentInfo agentInfo) {
            this.agentInfo = agentInfo;
            return this;
        }

        public Builder setEnvironment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public HostStatus build() {
            return new HostStatus(this.jobs, this.statuses, this.status, this.hostInfo, this.agentInfo, this.environment);
        }
    }

    public static enum Status {
        UP,
        DOWN;

    }
}

