/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Splitter;
import com.spotify.helios.common.descriptors.Descriptor;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServiceEndpoint
extends Descriptor
implements Comparable<ServiceEndpoint> {
    public static final String UDP = "udp";
    public static final String TCP = "tcp";
    public static final String HERMES = "hm";
    public static final String HTTP = "http";
    private final String name;
    private final String protocol;

    public ServiceEndpoint(String s) {
        List parts = Splitter.on((char)'/').splitToList((CharSequence)s);
        if (parts.size() < 1 || parts.size() > 2) {
            throw new IllegalArgumentException();
        }
        this.name = (String)parts.get(0);
        this.protocol = parts.size() > 1 ? (String)parts.get(1) : HTTP;
    }

    public ServiceEndpoint(@JsonProperty(value="name") String name, @JsonProperty(value="protocol") String protocol) {
        this.name = name;
        this.protocol = protocol;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public int compareTo(ServiceEndpoint o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceEndpoint that = (ServiceEndpoint)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name + "/" + this.protocol;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceEndpoint of(String service, String proto) {
        return new ServiceEndpoint(service, proto);
    }

    public static class Builder {
        private String name;
        private String protocol;

        public Builder() {
        }

        private Builder(ServiceEndpoint serviceEndpoint) {
            this.name = serviceEndpoint.name;
            this.protocol = serviceEndpoint.protocol;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public ServiceEndpoint build() {
            return new ServiceEndpoint(this.name, this.protocol);
        }
    }
}

