/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class SeparateMalwaresResponse extends AbstractModel{

    /**
    * 隔离成功的id数组，若无则返回空数组
    */
    @SerializedName("SuccessIds")
    @Expose
    private Long [] SuccessIds;

    /**
    * 隔离失败的id数组，若无则返回空数组
    */
    @SerializedName("FailedIds")
    @Expose
    private Long [] FailedIds;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 隔离成功的id数组，若无则返回空数组 
     * @return SuccessIds 隔离成功的id数组，若无则返回空数组
     */
    public Long [] getSuccessIds() {
        return this.SuccessIds;
    }

    /**
     * Set 隔离成功的id数组，若无则返回空数组
     * @param SuccessIds 隔离成功的id数组，若无则返回空数组
     */
    public void setSuccessIds(Long [] SuccessIds) {
        this.SuccessIds = SuccessIds;
    }

    /**
     * Get 隔离失败的id数组，若无则返回空数组 
     * @return FailedIds 隔离失败的id数组，若无则返回空数组
     */
    public Long [] getFailedIds() {
        return this.FailedIds;
    }

    /**
     * Set 隔离失败的id数组，若无则返回空数组
     * @param FailedIds 隔离失败的id数组，若无则返回空数组
     */
    public void setFailedIds(Long [] FailedIds) {
        this.FailedIds = FailedIds;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public SeparateMalwaresResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public SeparateMalwaresResponse(SeparateMalwaresResponse source) {
        if (source.SuccessIds != null) {
            this.SuccessIds = new Long[source.SuccessIds.length];
            for (int i = 0; i < source.SuccessIds.length; i++) {
                this.SuccessIds[i] = new Long(source.SuccessIds[i]);
            }
        }
        if (source.FailedIds != null) {
            this.FailedIds = new Long[source.FailedIds.length];
            for (int i = 0; i < source.FailedIds.length; i++) {
                this.FailedIds[i] = new Long(source.FailedIds[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "SuccessIds.", this.SuccessIds);
        this.setParamArraySimple(map, prefix + "FailedIds.", this.FailedIds);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

