/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import cn.hutool.core.map.MapUtil;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.AsrRequestContent;
import com.tencent.asr.model.SpeechRecognitionRequest;
import com.tencent.asr.model.SpeechRecognitionResponse;
import com.tencent.asr.model.SpeechRecognitionSysConfig;
import com.tencent.asr.service.SdkRunException;
import com.tencent.asr.service.SpeechRecognitionListener;
import com.tencent.asr.service.SpeechRecognitionSignService;
import com.tencent.asr.service.SpeechRecognizer;
import com.tencent.asr.service.TractionManager;
import com.tencent.asr.service.WsClientService;
import com.tencent.asr.utils.AsrUtils;
import com.tencent.core.service.ReportService;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.SignBuilder;
import com.tencent.core.utils.Tutils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.apache.commons.lang3.StringUtils;

public class SpeechWsRecognizer
implements SpeechRecognizer {
    protected AsrConfig asrConfig;
    protected SpeechRecognitionRequest asrRequest;
    protected AsrRequestContent asrRequestContent;
    protected SpeechRecognitionListener listener;
    protected WebSocket webSocket;
    protected int reConnectMaxNum = 10;
    protected int connectNum = 0;
    protected volatile boolean isConnect = false;
    protected volatile AtomicBoolean endFlag = new AtomicBoolean(false);
    protected volatile AtomicBoolean startFlag = new AtomicBoolean(false);
    protected SpeechRecognitionSignService speechRecognitionSignService = new SpeechRecognitionSignService();
    private ReentrantLock lock = new ReentrantLock();
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private boolean begin = false;
    private AtomicLong adder = new AtomicLong(0L);
    private TractionManager tractionManager;
    private WsClientService wsClientService;

    public SpeechWsRecognizer(WsClientService wsClientService, String streamId, AsrConfig config, SpeechRecognitionRequest request, SpeechRecognitionListener listener) {
        this.wsClientService = wsClientService;
        this.asrConfig = config;
        this.asrRequest = request;
        if (StringUtils.isEmpty((CharSequence)request.getVoiceId())) {
            request.setVoiceId(AsrUtils.getVoiceId(config.getAppId()));
        }
        this.asrRequestContent = AsrRequestContent.builder().seq(0).end(0).streamId(streamId).voiceId(request.getVoiceId()).build();
        this.listener = listener;
        this.tractionManager = new TractionManager(config.getAppId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean createWebsocket() throws SdkRunException {
        if (!this.isConnect || this.webSocket == null) {
            try {
                this.lock.lock();
                if (!this.isConnect || this.webSocket == null) {
                    ReportService.ifLogMessage(this.getId(), "create websocket", false);
                    this.asrRequest.setTimestamp(System.currentTimeMillis() / 1000L);
                    this.asrRequest.setExpired(System.currentTimeMillis() / 1000L + 86400L);
                    String url = this.speechRecognitionSignService.signWsUrl(this.asrConfig, this.asrRequest, this.asrRequestContent);
                    String sign = SignBuilder.createGetSign(url, this.asrConfig.getSecretKey(), this.asrRequest);
                    WebSocketListener webSocketListener = this.createWebSocketListener();
                    this.webSocket = this.wsClientService.asrWebSocket(this.asrConfig.getToken(), url, sign, webSocketListener);
                    this.isConnect = true;
                    boolean countDown = this.startLatch.await(SpeechRecognitionSysConfig.wsStartMethodWait, TimeUnit.SECONDS);
                    if (!countDown) {
                        throw new SdkRunException(AsrConstant.Code.CODE_10001);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    @Override
    public void start() throws SdkRunException {
        Boolean success = this.createWebsocket();
        if (success.booleanValue()) {
            this.startFlag.set(true);
            this.tractionManager.beginTraction(this.asrRequestContent.getStreamId());
        }
    }

    @Override
    public void write(byte[] data) throws SdkRunException {
        if (!this.startFlag.get()) {
            ReportService.ifLogMessage(this.getId(), "method " + this.adder.get() + " package please call start method!!", false);
            throw new SdkRunException(AsrConstant.Code.CODE_10002);
        }
        if (this.endFlag.get()) {
            ReportService.ifLogMessage(this.getId(), "method " + this.adder.get() + " can`t write,because you call stop method or send message fail", false);
            throw new SdkRunException(AsrConstant.Code.CODE_10003);
        }
        if (!this.isConnect) {
            ReportService.ifLogMessage(this.getId(), "method " + this.adder.get() + " client is closing", false);
            throw new SdkRunException(AsrConstant.Code.CODE_10004);
        }
        ReportService.ifLogMessage(this.getId(), "send " + this.adder.get() + " package", false);
        boolean success = this.webSocket.send(ByteString.of((byte[])data));
        ReportService.ifLogMessage(this.getId(), "send " + this.adder.get() + " package " + success, false);
        this.adder.incrementAndGet();
        if (!success) {
            for (int i = 0; i < SpeechRecognitionSysConfig.retryRequestNum && !(success = this.webSocket.send(ByteString.of((byte[])data))); ++i) {
            }
        }
    }

    private void write(String data) {
        if (!this.endFlag.get()) {
            ReportService.ifLogMessage(this.getId(), "send " + this.adder.get() + " end package", false);
            this.adder.incrementAndGet();
            this.webSocket.send(data);
        }
    }

    @Override
    public Boolean stop() {
        if (this.endFlag.get()) {
            return true;
        }
        this.write(JsonUtil.toJson(MapUtil.builder().put((Object)"type", (Object)"end").build()));
        this.endFlag.set(true);
        try {
            this.closeLatch.await(SpeechRecognitionSysConfig.wsStopMethodWait, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ReportService.ifLogMessage(this.getId(), "stop_exception:" + e.getMessage(), false);
        }
        return true;
    }

    private WebSocketListener createWebSocketListener() {
        return new WebSocketListener(){

            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "ws onClosed" + reason, false);
                SpeechWsRecognizer.this.isConnect = false;
                SpeechWsRecognizer.this.countDownStop("onClosed");
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "ws onClosing", false);
                SpeechWsRecognizer.this.isConnect = false;
                SpeechWsRecognizer.this.countDownStop("onClosing");
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                SpeechWsRecognizer.this.isConnect = false;
                SpeechWsRecognizer.this.countDownStart("onFailure");
                SpeechWsRecognizer.this.countDownStop("onFailure");
                String trace = Tutils.getStackTrace(t);
                if (trace != null && StringUtils.contains((CharSequence)trace, (CharSequence)"Socket closed")) {
                    return;
                }
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onFailure:" + trace, true);
                SpeechRecognitionResponse rs = new SpeechRecognitionResponse();
                rs.setCode(AsrConstant.Code.EXCEPTION.getCode());
                rs.setMessage(trace);
                rs.setStreamId(SpeechWsRecognizer.this.asrRequestContent.getStreamId());
                rs.setVoiceId(SpeechWsRecognizer.this.asrRequestContent.getVoiceId());
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onFailure", false);
                ReportService.report(false, String.valueOf(rs.getCode()), SpeechWsRecognizer.this.asrConfig, SpeechWsRecognizer.this.getId(), SpeechWsRecognizer.this.asrRequest, rs, SpeechWsRecognizer.this.asrConfig.getWsUrl(), t.getMessage());
                SpeechWsRecognizer.this.listener.onFail(rs);
            }

            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onMessage:" + text, false);
                SpeechRecognitionResponse response = JsonUtil.fromJson(text, SpeechRecognitionResponse.class);
                if (SpeechWsRecognizer.this.listener != null && response != null) {
                    SpeechWsRecognizer.this.listener.onMessage(response);
                    if (response.getCode() == 0) {
                        SpeechWsRecognizer.this.resultCallBack(response);
                        ReportService.report(true, String.valueOf(response.getCode()), SpeechWsRecognizer.this.asrConfig, SpeechWsRecognizer.this.getId(), SpeechWsRecognizer.this.asrRequest, response, SpeechWsRecognizer.this.asrConfig.getWsUrl(), response.getMessage());
                    } else {
                        ReportService.report(false, String.valueOf(response.getCode()), SpeechWsRecognizer.this.asrConfig, SpeechWsRecognizer.this.getId(), SpeechWsRecognizer.this.asrRequest, response, SpeechWsRecognizer.this.asrConfig.getWsUrl(), response.getMessage());
                        response.setStreamId(SpeechWsRecognizer.this.asrRequestContent.getStreamId());
                        response.setVoiceId(SpeechWsRecognizer.this.asrRequestContent.getVoiceId());
                        SpeechWsRecognizer.this.endFlag.set(true);
                        webSocket.cancel();
                        SpeechWsRecognizer.this.listener.onFail(response);
                    }
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
            }

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onOpen:" + JsonUtil.toJson(response), false);
                boolean bl = SpeechWsRecognizer.this.isConnect = response.code() == 101;
                if (!SpeechWsRecognizer.this.isConnect) {
                    ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onOpen: fail", false);
                    webSocket.close(1001, "onOpen");
                }
                SpeechWsRecognizer.this.countDownStart("onOpen");
                if (SpeechWsRecognizer.this.listener != null) {
                    SpeechRecognitionResponse recognitionResponse = new SpeechRecognitionResponse();
                    recognitionResponse.setCode(0);
                    recognitionResponse.setStreamId(SpeechWsRecognizer.this.asrRequestContent.getStreamId());
                    recognitionResponse.setFinalSpeech(0);
                    recognitionResponse.setVoiceId(SpeechWsRecognizer.this.asrRequestContent.getVoiceId());
                    recognitionResponse.setMessage("success");
                    SpeechWsRecognizer.this.listener.onRecognitionStart(recognitionResponse);
                }
            }
        };
    }

    private void resultCallBack(SpeechRecognitionResponse response) {
        response.setStreamId(this.asrRequestContent.getStreamId());
        if (response.getFinalSpeech() == null) {
            response.setFinalSpeech(0);
        }
        if (response.getResult() != null && this.listener != null) {
            if (response.getResult().getSliceType() == 0) {
                this.begin = true;
                this.listener.onSentenceBegin(response);
            } else if (response.getResult().getSliceType() == 2) {
                if (!this.begin) {
                    SpeechRecognitionResponse beginResp = JsonUtil.fromJson(JsonUtil.toJson(response), SpeechRecognitionResponse.class);
                    beginResp.getResult().setSliceType(0);
                    this.listener.onSentenceBegin(beginResp);
                }
                this.begin = false;
                this.listener.onSentenceEnd(response);
            } else {
                this.listener.onRecognitionResultChange(response);
            }
        }
        if (response.getFinalSpeech() != null && response.getFinalSpeech() == 1) {
            if (this.listener != null) {
                SpeechRecognitionResponse recognizerResponse = new SpeechRecognitionResponse();
                recognizerResponse.setCode(0);
                recognizerResponse.setVoiceId(this.asrRequestContent.getVoiceId());
                recognizerResponse.setFinalSpeech(1);
                recognizerResponse.setStreamId(this.asrRequestContent.getStreamId());
                recognizerResponse.setMessage("success");
                recognizerResponse.setMessageId(response.getMessageId());
                this.listener.onRecognitionComplete(recognizerResponse);
            }
            this.countDownStop("final");
            this.webSocket.cancel();
        }
    }

    private String getId() {
        return this.asrRequestContent.getStreamId() + "_" + this.asrRequestContent.getVoiceId();
    }

    private void reconnect(byte[] data) {
        if (this.endFlag.get()) {
            return;
        }
        if (this.connectNum <= this.reConnectMaxNum) {
            try {
                Thread.sleep(10L);
                this.write(data);
                ++this.connectNum;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void countDownStop(String source) {
        try {
            if (this.closeLatch.getCount() > 0L) {
                this.closeLatch.countDown();
                ReportService.ifLogMessage(this.asrRequestContent.getVoiceId(), source + "_closeLatch_countDown", false);
            }
        }
        catch (Exception e) {
            ReportService.ifLogMessage(this.asrRequestContent.getVoiceId(), source + "_closeLatch_exception" + e.getMessage(), true);
        }
    }

    private void countDownStart(String source) {
        try {
            if (this.startLatch.getCount() > 0L) {
                this.startLatch.countDown();
                ReportService.ifLogMessage(this.asrRequestContent.getVoiceId(), source + "_startLatch_countDown", false);
            }
        }
        catch (Exception e) {
            ReportService.ifLogMessage(this.asrRequestContent.getVoiceId(), source + " _startLatch_countDown" + e.getMessage(), true);
        }
    }
}

