/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import com.tencent.asr.model.SpeechWebsocketConfig;
import com.tencent.core.model.GlobalConfig;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;

public class WsClientService {
    protected OkHttpClient client;

    public WsClientService(SpeechWebsocketConfig config) {
        ExecutorService treadPool = config.getExecutorService();
        if (config.getExecutorService() == null) {
            treadPool = new ThreadPoolExecutor((int)config.getWsMaxRequests(), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"OkHttp Dispatcher", (boolean)false));
        }
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder();
        okHttpBuilder.dispatcher(new Dispatcher(treadPool)).connectionPool(new ConnectionPool(config.getWsMaxIdleConnections().intValue(), (long)config.getWsKeepAliveDuration().intValue(), TimeUnit.MILLISECONDS)).writeTimeout((long)config.getWsWriteTimeOut().intValue(), TimeUnit.MILLISECONDS).readTimeout((long)config.getWsReadTimeOut().intValue(), TimeUnit.MILLISECONDS).connectTimeout((long)config.getWsConnectTimeOut().intValue(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);
        if (GlobalConfig.ifLog) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            okHttpBuilder.addInterceptor((Interceptor)loggingInterceptor);
        }
        if (config.getUseProxy() != null && config.getUseProxy().booleanValue()) {
            if (config.getAuthenticator() != null) {
                okHttpBuilder.authenticator(config.getAuthenticator());
            }
            if (config.getProxySelector() != null) {
                okHttpBuilder.proxySelector(config.getProxySelector());
            } else {
                okHttpBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxyHost(), (int)config.getProxyPort())));
            }
        }
        this.client = okHttpBuilder.build();
        this.client.dispatcher().setMaxRequests(config.getWsMaxRequests().intValue());
        this.client.dispatcher().setMaxRequestsPerHost(config.getWsMaxRequestsPerHost().intValue());
    }

    public WebSocket asrWebSocket(String token, String wsUrl, String sign, WebSocketListener listener) {
        Headers.Builder builder = new Headers.Builder().add("Authorization", sign).add("Host", "asr.cloud.tencent.com");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            builder.add("X-TC-Token", token);
        }
        Headers headers = builder.build();
        Request request = new Request.Builder().url(wsUrl).headers(headers).build();
        WebSocket webSocket = this.client.newWebSocket(request, listener);
        return webSocket;
    }
}

