/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.service;

import com.tencent.core.model.GlobalConfig;
import com.tencent.core.model.ReportInfo;
import com.tencent.core.model.TConfig;
import com.tencent.core.service.StatService;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.Tutils;
import com.tencentcloudapi.asr.v20190614.AsrClient;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.commons.lang3.StringUtils;

public class ReportService {
    private static ExpiringMap<String, String> errorMap = ExpiringMap.builder().maxSize(200).expiration(60L, TimeUnit.SECONDS).variableExpiration().expirationPolicy(ExpirationPolicy.CREATED).build();

    public static void report(Boolean success, String code, TConfig config, String id, Object request, Object response, String url, String e) {
        ReportService.report(success, code, config, id, request, response, url, e, 0L);
    }

    public static void report(Boolean success, String code, TConfig config, String id, Object request, Object response, String url, String e, long delayTime) {
        try {
            if (GlobalConfig.ifOpenStat.booleanValue()) {
                StatService.statAsr(success, code, delayTime);
                StatService.heartbeat();
            }
            if (GlobalConfig.ifOpenReportError.booleanValue() && !success.booleanValue()) {
                ReportService.filterRepeatError(config, id, request, response, url, e, delayTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterRepeatError(final TConfig config, final String id, final Object request, final Object response, final String url, final String e, final long delayTime) {
        Class<ReportService> clazz = ReportService.class;
        synchronized (ReportService.class) {
            if (errorMap.containsKey((Object)id)) {
                // ** MonitorExit[var8_7] (shouldn't be in output)
                return;
            }
            errorMap.put((Object)id, (Object)String.valueOf(e));
            // ** MonitorExit[var8_7] (shouldn't be in output)
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ReportService.reportError(config, id, request, response, url, e, delayTime);
                }
            }).start();
            return;
        }
    }

    public static void filterRepeatError(TConfig config, String id, Object request, Object response, String url, String e) {
        ReportService.filterRepeatError(config, id, request, response, url, e, 0L);
    }

    public static void reportError(TConfig config, String id, Object request, Object response, String url, String e, long delayTime) {
        ReportInfo reportInfo = new ReportInfo();
        ReportInfo.Log log = ReportInfo.Log.builder().request(request).url(url).delayTime(delayTime).response(response).time(Tutils.getNowData()).build();
        reportInfo.setLog(JsonUtil.toJson(log));
        ReportInfo.AppInfo appInfo = ReportInfo.getAppInfo(e, "_ERROR");
        reportInfo.setAppInfo(JsonUtil.toJson(appInfo));
        ReportService.doReportError(config.getSecretId(), config.getSecretKey(), config.getToken(), id, reportInfo);
    }

    public static void doReportError(String secretId, String secretKey, String token, String id, Object data) {
        try {
            Credential cred = StringUtils.isNotEmpty((CharSequence)token) ? new Credential(secretId, secretKey, token) : new Credential(secretId, secretKey);
            AsrClient client = new AsrClient(cred, GlobalConfig.region);
            String string = client.call("UploadSDKLog", JsonUtil.toJson(data));
        }
        catch (TencentCloudSDKException tencentCloudSDKException) {
            // empty catch block
        }
    }

    public static void ifLogMessage(String id, String message, Boolean error) {
        if (GlobalConfig.ifLog) {
            id = Optional.ofNullable(id).orElse("");
            if (error.booleanValue()) {
                GlobalConfig.sdkLogInterceptor.error(id + "||" + message);
            } else {
                GlobalConfig.sdkLogInterceptor.info(id + "||" + message);
            }
        }
    }
}

