/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tts.utils;

import com.tencent.core.service.ReportService;
import com.tencent.core.utils.ByteUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class OpusUtils {
    public static int convertGoByte2Int(byte[] bytes) {
        if (bytes == null || bytes.length != 4) {
            return 0;
        }
        byte b1 = bytes[0];
        byte b2 = bytes[1];
        byte b3 = bytes[2];
        byte b4 = bytes[3];
        return OpusUtils.getUint8(b1) * 1 + OpusUtils.getUint8(b2) * 256 + OpusUtils.getUint8(b3) * 256 * 256 + OpusUtils.getUint8(b4) * 256 * 256 * 256;
    }

    public static int getUint8(short s) {
        return s & 0xFF;
    }

    public static boolean verifyHeader(byte[] headBuffer) {
        String header = new String(headBuffer);
        return header.equals("opus");
    }

    public static boolean read(InputStream in, byte[] buffer) throws IOException {
        int currentRead;
        int length = buffer.length;
        int offset = 0;
        do {
            int count;
            if ((currentRead = in.read(buffer, offset, count = length - offset)) < 0 || (offset += currentRead) != length) continue;
            return true;
        } while (currentRead != -1);
        return false;
    }

    public static List<byte[]> readOpusSheet(byte[] audio) {
        byte[] data = ByteUtils.copy(audio);
        int lengthSum = 0;
        ArrayList<byte[]> sheets = new ArrayList<byte[]>();
        while (true) {
            if (data.length < 4) {
                return sheets;
            }
            byte[] headBytes = ByteUtils.subBytes(data, 0, 4);
            if (!OpusUtils.verifyHeader(headBytes)) {
                ReportService.ifLogMessage("readOpus", "Get header values abnormal, not opus but: " + new String(headBytes), false);
                break;
            }
            if (data.length < 8) {
                ReportService.ifLogMessage("readOpus", "Get seq values abnormal, not seq  ", false);
                return sheets;
            }
            byte[] seqBytes = ByteUtils.subBytes(data, 4, 4);
            int seq = OpusUtils.convertGoByte2Int(seqBytes);
            if (seq < -1) {
                ReportService.ifLogMessage("readOpus", "Get seq abnormal: " + seq, false);
                break;
            }
            if (data.length < 12) {
                return sheets;
            }
            byte[] lengthBytes = ByteUtils.subBytes(data, 8, 4);
            int length = OpusUtils.convertGoByte2Int(lengthBytes);
            ReportService.ifLogMessage("readOpus", "seq:" + seq + ",length:" + length, false);
            if (seq == -1) {
                byte[] leftBytes = ByteUtils.subBytes(data, 8, data.length - 8);
                ReportService.ifLogMessage("readOpus end", new String(leftBytes), false);
                break;
            }
            if (length <= 0) break;
            byte[] datas = new byte[]{};
            if (length > 0) {
                length = data.length - 12 < length ? data.length - 12 : length;
                datas = ByteUtils.subBytes(data, 12, length);
            }
            byte[] result = new byte[]{};
            result = ByteUtils.concat(result, headBytes);
            result = ByteUtils.concat(result, seqBytes);
            result = ByteUtils.concat(result, lengthBytes);
            result = ByteUtils.concat(result, datas);
            sheets.add(result);
            lengthSum = lengthSum + length + 12;
            data = ByteUtils.subBytes(data, 12 + length, data.length - 12 - length);
        }
        return sheets;
    }
}

