/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import cn.hutool.core.util.RandomUtil;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.Credential;
import com.tencent.asr.model.SpeechRecognitionRequest;
import com.tencent.asr.model.SpeechRecognitionSysConfig;
import com.tencent.asr.model.SpeechWebsocketConfig;
import com.tencent.asr.service.FlashRecognizer;
import com.tencent.asr.service.SdkRunException;
import com.tencent.asr.service.SpeechHttpRecognizer;
import com.tencent.asr.service.SpeechRecognitionListener;
import com.tencent.asr.service.SpeechRecognizer;
import com.tencent.asr.service.SpeechWsRecognizer;
import com.tencent.asr.service.WsClientService;
import com.tencent.core.model.GlobalConfig;
import com.tencent.core.service.StatService;
import com.tencent.tts.model.SpeechSynthesisConfig;
import com.tencent.tts.model.SpeechSynthesisRequest;
import com.tencent.tts.service.SpeechSynthesisListener;
import com.tencent.tts.service.SpeechSynthesizer;
import org.apache.commons.lang3.StringUtils;

public class SpeechClient {
    private static SpeechClient speechClient;
    private String appId;
    private String secretId;
    private String secretKey;
    private String token;
    private WsClientService wsClientService;

    private SpeechClient() {
    }

    public static SpeechClient newInstance(String appId, String secretId, String secretKey) {
        return SpeechClient.newInstance(appId, secretId, secretKey, null);
    }

    public static SpeechClient newInstance(String appId, String secretId, String secretKey, String token) {
        return SpeechClient.newInstance(appId, secretId, secretKey, token, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpeechClient newInstance(String appId, String secretId, String secretKey, String token, SpeechWebsocketConfig config) {
        if (StringUtils.isEmpty((CharSequence)secretId)) {
            throw new SdkRunException(AsrConstant.Code.CODE_10009);
        }
        if (StringUtils.isEmpty((CharSequence)secretKey)) {
            throw new SdkRunException(AsrConstant.Code.CODE_10009);
        }
        if (speechClient != null) return speechClient;
        Class<SpeechClient> clazz = SpeechClient.class;
        synchronized (SpeechClient.class) {
            if (speechClient != null) return speechClient;
            speechClient = new SpeechClient();
            speechClient.setAppId(appId);
            speechClient.setSecretId(secretId);
            speechClient.setSecretKey(secretKey);
            speechClient.setToken(token);
            if (AsrConstant.RequestWay.Websocket.equals((Object)SpeechRecognitionSysConfig.requestWay)) {
                if (config == null) {
                    config = SpeechWebsocketConfig.init();
                }
                SpeechClient.speechClient.wsClientService = new WsClientService(config);
            }
            if (!GlobalConfig.ifOpenStat.booleanValue()) return speechClient;
            StatService.setConfig(secretId, secretKey, appId, token);
            StatService.startReportStat();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return speechClient;
        }
    }

    public void setSpeechClientConfig(String appId, String secretId, String secretKey, String token) {
        if (speechClient != null) {
            speechClient.setAppId(appId);
            speechClient.setSecretId(secretId);
            speechClient.setSecretKey(secretKey);
            speechClient.setToken(token);
            if (GlobalConfig.ifOpenStat.booleanValue()) {
                StatService.setConfig(secretId, secretKey, appId, token);
            }
        }
    }

    public SpeechSynthesizer newSpeechSynthesizer(SpeechSynthesisRequest speechSynthesisRequest, SpeechSynthesisListener eventListener) {
        SpeechSynthesisConfig config = SpeechSynthesisConfig.builder().appId(Long.valueOf(this.appId)).secretId(this.secretId).secretKey(this.secretKey).token(this.token).build();
        return new SpeechSynthesizer(config, speechSynthesisRequest, eventListener);
    }

    public SpeechRecognizer newSpeechRecognizer(SpeechRecognitionRequest request, SpeechRecognitionListener speechRecognitionListener) {
        AsrConfig config = AsrConfig.builder().appId(this.appId).secretId(this.secretId).secretKey(this.secretKey).token(this.token).build();
        if (request.getEngineModelType() == null) {
            throw new RuntimeException("engineModelType can not be null,please set SpeechRecognitionRequest EngineModelType !!");
        }
        if (AsrConstant.RequestWay.Http.equals((Object)SpeechRecognitionSysConfig.requestWay)) {
            return new SpeechHttpRecognizer(RandomUtil.randomString((int)8), config, request, speechRecognitionListener);
        }
        return this.newWsSpeechRecognizer(request, speechRecognitionListener);
    }

    public SpeechRecognizer newWsSpeechRecognizer(SpeechRecognitionRequest request, SpeechRecognitionListener speechRecognitionListener) {
        AsrConfig config = AsrConfig.builder().appId(this.appId).secretId(this.secretId).secretKey(this.secretKey).token(this.token).build();
        if (request.getEngineModelType() == null) {
            throw new RuntimeException("engineModelType can not be null,please set SpeechRecognitionRequest EngineModelType !!");
        }
        return new SpeechWsRecognizer(this.wsClientService, RandomUtil.randomString((int)8), config, request, speechRecognitionListener);
    }

    public static FlashRecognizer newFlashRecognizer(String appId, Credential credential) {
        AsrConfig config = AsrConfig.builder().appId(appId).secretId(credential.getSecretId()).secretKey(credential.getSecretKey()).token(credential.getToken()).build();
        return new FlashRecognizer(config);
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setWsClientService(WsClientService wsClientService) {
        this.wsClientService = wsClientService;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getToken() {
        return this.token;
    }

    public WsClientService getWsClientService() {
        return this.wsClientService;
    }
}

