/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.model;

import com.tencent.core.model.TConfig;
import java.util.Optional;

public class AsrConfig
extends TConfig {
    private Long waitTime;
    private String realAsrUrl;
    private String signUrl;
    private String logUrl;
    private String wsUrl;
    private String wsSignUrl;
    private String flashUrl;
    private String flashSignUrl;

    private AsrConfig() {
    }

    public AsrConfig(String appId, String secretKey, String secretId, Long waitTime, String realAsrUrl, String signUrl, String logUrl, String wsUrl, String token) {
        super(secretId, secretKey, Long.valueOf(appId), token);
        this.realAsrUrl = Optional.ofNullable(realAsrUrl).orElse("https://asr.cloud.tencent.com/asr/v1/");
        this.signUrl = Optional.ofNullable(signUrl).orElse("asr.cloud.tencent.com/asr/v1/");
        this.logUrl = Optional.ofNullable(logUrl).orElse("https://asr.tencentcloudapi.com/");
        this.wsUrl = Optional.ofNullable(wsUrl).orElse("wss://asr.cloud.tencent.com/asr/v2/");
        this.wsSignUrl = "asr.cloud.tencent.com/asr/v2/";
        this.flashUrl = "https://asr.cloud.tencent.com/asr/flash/v1/";
        this.flashSignUrl = "asr.cloud.tencent.com/asr/flash/v1/";
        this.waitTime = Optional.ofNullable(waitTime).orElse(6000L);
    }

    public static AsrConfigBuilder builder() {
        return new AsrConfigBuilder();
    }

    public Long getWaitTime() {
        return this.waitTime;
    }

    public String getRealAsrUrl() {
        return this.realAsrUrl;
    }

    public String getSignUrl() {
        return this.signUrl;
    }

    public String getLogUrl() {
        return this.logUrl;
    }

    public String getWsUrl() {
        return this.wsUrl;
    }

    public String getWsSignUrl() {
        return this.wsSignUrl;
    }

    public String getFlashUrl() {
        return this.flashUrl;
    }

    public String getFlashSignUrl() {
        return this.flashSignUrl;
    }

    public void setWaitTime(Long waitTime) {
        this.waitTime = waitTime;
    }

    public void setRealAsrUrl(String realAsrUrl) {
        this.realAsrUrl = realAsrUrl;
    }

    public void setSignUrl(String signUrl) {
        this.signUrl = signUrl;
    }

    public void setLogUrl(String logUrl) {
        this.logUrl = logUrl;
    }

    public void setWsUrl(String wsUrl) {
        this.wsUrl = wsUrl;
    }

    public void setWsSignUrl(String wsSignUrl) {
        this.wsSignUrl = wsSignUrl;
    }

    public void setFlashUrl(String flashUrl) {
        this.flashUrl = flashUrl;
    }

    public void setFlashSignUrl(String flashSignUrl) {
        this.flashSignUrl = flashSignUrl;
    }

    public static class AsrConfigBuilder {
        private String appId;
        private String secretKey;
        private String secretId;
        private Long waitTime;
        private String realAsrUrl;
        private String signUrl;
        private String logUrl;
        private String wsUrl;
        private String token;

        AsrConfigBuilder() {
        }

        public AsrConfigBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public AsrConfigBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public AsrConfigBuilder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public AsrConfigBuilder waitTime(Long waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public AsrConfigBuilder realAsrUrl(String realAsrUrl) {
            this.realAsrUrl = realAsrUrl;
            return this;
        }

        public AsrConfigBuilder signUrl(String signUrl) {
            this.signUrl = signUrl;
            return this;
        }

        public AsrConfigBuilder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public AsrConfigBuilder wsUrl(String wsUrl) {
            this.wsUrl = wsUrl;
            return this;
        }

        public AsrConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public AsrConfig build() {
            return new AsrConfig(this.appId, this.secretKey, this.secretId, this.waitTime, this.realAsrUrl, this.signUrl, this.logUrl, this.wsUrl, this.token);
        }

        public String toString() {
            return "AsrConfig.AsrConfigBuilder(appId=" + this.appId + ", secretKey=" + this.secretKey + ", secretId=" + this.secretId + ", waitTime=" + this.waitTime + ", realAsrUrl=" + this.realAsrUrl + ", signUrl=" + this.signUrl + ", logUrl=" + this.logUrl + ", wsUrl=" + this.wsUrl + ", token=" + this.token + ")";
        }
    }
}

