/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.core.model.GlobalConfig;
import com.tencent.core.model.LogStatistics;
import com.tencent.core.utils.Tutils;

public class ReportInfo {
    @JsonProperty(value="Log")
    private String Log;
    @JsonProperty(value="AppInfo")
    private String AppInfo;

    public static AppInfo getAppInfo(String e, String type) {
        AppInfo appInfo = new AppInfo();
        appInfo.setOsVer(System.getProperty("os.version"));
        appInfo.setOsName(System.getProperty("os.name"));
        appInfo.setAppVerName(GlobalConfig.appVerName);
        appInfo.setAppVerCode(GlobalConfig.appVerCode);
        appInfo.setSdk(GlobalConfig.getSdk() + type);
        appInfo.setSdkVer(GlobalConfig.getSdkVer());
        appInfo.setTime(Tutils.getNowData());
        appInfo.setException(e);
        return appInfo;
    }

    @JsonProperty(value="Log")
    public void setLog(String Log2) {
        this.Log = Log2;
    }

    @JsonProperty(value="AppInfo")
    public void setAppInfo(String AppInfo2) {
        this.AppInfo = AppInfo2;
    }

    public String getLog() {
        return this.Log;
    }

    public String getAppInfo() {
        return this.AppInfo;
    }

    public ReportInfo() {
    }

    public ReportInfo(String Log2, String AppInfo2) {
        this.Log = Log2;
        this.AppInfo = AppInfo2;
    }

    public static class AppInfo {
        @JsonProperty(value="Time")
        private String time;
        @JsonProperty(value="OsVer")
        private String osVer;
        @JsonProperty(value="OsName")
        private String osName;
        @JsonProperty(value="Sdk")
        private String sdk;
        @JsonProperty(value="SdkVer")
        private String sdkVer;
        @JsonProperty(value="Exception")
        private String exception;
        @JsonProperty(value="AppVerName")
        private String appVerName;
        @JsonProperty(value="AppVerCode")
        private String appVerCode;

        @JsonProperty(value="Time")
        public void setTime(String time) {
            this.time = time;
        }

        @JsonProperty(value="OsVer")
        public void setOsVer(String osVer) {
            this.osVer = osVer;
        }

        @JsonProperty(value="OsName")
        public void setOsName(String osName) {
            this.osName = osName;
        }

        @JsonProperty(value="Sdk")
        public void setSdk(String sdk) {
            this.sdk = sdk;
        }

        @JsonProperty(value="SdkVer")
        public void setSdkVer(String sdkVer) {
            this.sdkVer = sdkVer;
        }

        @JsonProperty(value="Exception")
        public void setException(String exception) {
            this.exception = exception;
        }

        @JsonProperty(value="AppVerName")
        public void setAppVerName(String appVerName) {
            this.appVerName = appVerName;
        }

        @JsonProperty(value="AppVerCode")
        public void setAppVerCode(String appVerCode) {
            this.appVerCode = appVerCode;
        }

        public String getTime() {
            return this.time;
        }

        public String getOsVer() {
            return this.osVer;
        }

        public String getOsName() {
            return this.osName;
        }

        public String getSdk() {
            return this.sdk;
        }

        public String getSdkVer() {
            return this.sdkVer;
        }

        public String getException() {
            return this.exception;
        }

        public String getAppVerName() {
            return this.appVerName;
        }

        public String getAppVerCode() {
            return this.appVerCode;
        }
    }

    public static class Log {
        @JsonProperty(value="DelayTime")
        private long delayTime;
        @JsonProperty(value="Time")
        private String time;
        @JsonProperty(value="Response")
        private Object response;
        @JsonProperty(value="Request")
        private Object request;
        @JsonProperty(value="Url")
        private String url;
        @JsonProperty(value="Stat")
        private LogStatistics stat;
        @JsonProperty(value="Sign")
        private String sign;

        public static LogBuilder builder() {
            return new LogBuilder();
        }

        @JsonProperty(value="DelayTime")
        public void setDelayTime(long delayTime) {
            this.delayTime = delayTime;
        }

        @JsonProperty(value="Time")
        public void setTime(String time) {
            this.time = time;
        }

        @JsonProperty(value="Response")
        public void setResponse(Object response) {
            this.response = response;
        }

        @JsonProperty(value="Request")
        public void setRequest(Object request) {
            this.request = request;
        }

        @JsonProperty(value="Url")
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty(value="Stat")
        public void setStat(LogStatistics stat) {
            this.stat = stat;
        }

        @JsonProperty(value="Sign")
        public void setSign(String sign) {
            this.sign = sign;
        }

        public long getDelayTime() {
            return this.delayTime;
        }

        public String getTime() {
            return this.time;
        }

        public Object getResponse() {
            return this.response;
        }

        public Object getRequest() {
            return this.request;
        }

        public String getUrl() {
            return this.url;
        }

        public LogStatistics getStat() {
            return this.stat;
        }

        public String getSign() {
            return this.sign;
        }

        public Log() {
        }

        public Log(long delayTime, String time, Object response, Object request, String url, LogStatistics stat, String sign) {
            this.delayTime = delayTime;
            this.time = time;
            this.response = response;
            this.request = request;
            this.url = url;
            this.stat = stat;
            this.sign = sign;
        }

        public static class LogBuilder {
            private long delayTime;
            private String time;
            private Object response;
            private Object request;
            private String url;
            private LogStatistics stat;
            private String sign;

            LogBuilder() {
            }

            @JsonProperty(value="DelayTime")
            public LogBuilder delayTime(long delayTime) {
                this.delayTime = delayTime;
                return this;
            }

            @JsonProperty(value="Time")
            public LogBuilder time(String time) {
                this.time = time;
                return this;
            }

            @JsonProperty(value="Response")
            public LogBuilder response(Object response) {
                this.response = response;
                return this;
            }

            @JsonProperty(value="Request")
            public LogBuilder request(Object request) {
                this.request = request;
                return this;
            }

            @JsonProperty(value="Url")
            public LogBuilder url(String url) {
                this.url = url;
                return this;
            }

            @JsonProperty(value="Stat")
            public LogBuilder stat(LogStatistics stat) {
                this.stat = stat;
                return this;
            }

            @JsonProperty(value="Sign")
            public LogBuilder sign(String sign) {
                this.sign = sign;
                return this;
            }

            public Log build() {
                return new Log(this.delayTime, this.time, this.response, this.request, this.url, this.stat, this.sign);
            }

            public String toString() {
                return "ReportInfo.Log.LogBuilder(delayTime=" + this.delayTime + ", time=" + this.time + ", response=" + this.response + ", request=" + this.request + ", url=" + this.url + ", stat=" + this.stat + ", sign=" + this.sign + ")";
            }
        }
    }
}

