/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tts.utils;

import com.tencent.core.service.ReportService;
import com.tencent.tts.utils.PcmUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Ttsutils {
    public static String responsePcm2Wav(int sampleRate, byte[] response, String sessionId) {
        return Ttsutils.printAndSaveResponse(sampleRate, response, sessionId);
    }

    public static String printAndSaveResponse(int sampleRate, byte[] response, String sessionId) {
        if (response != null) {
            new File("logs").mkdirs();
            int rspLen = response.length;
            byte[] wav = new byte[44 + rspLen];
            int bitNum = sampleRate == 16000 ? 16 : 8;
            PcmUtils.Pcm2WavBytes(response, wav, sampleRate, 1, bitNum);
            File wavFile = new File(sessionId + ".wav");
            Ttsutils.saveWavFile(wav, wavFile);
            ReportService.ifLogMessage(sessionId, "Response: " + sessionId + ", length: " + response.length + ", result saved at: " + wavFile.getAbsolutePath(), false);
            return wavFile.getAbsolutePath();
        }
        ReportService.ifLogMessage(sessionId, "Result is null.", true);
        return null;
    }

    private static void saveWavFile(byte[] response, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file, false);
            out.write(response);
            out.close();
        }
        catch (IOException e) {
            ReportService.ifLogMessage("saveWavFile", "Failed save data to: " + file + ", error: " + e.getMessage(), true);
        }
    }

    public static int fill(InputStream in, byte[] buffer) throws IOException {
        int currentRead;
        int length = buffer.length;
        int offset = 0;
        do {
            int count;
            if ((currentRead = in.read(buffer, offset, count = length - offset)) < 0 || (offset += currentRead) != length) continue;
            return length;
        } while (currentRead != -1);
        return offset;
    }

    public static void saveResponseToFile(byte[] response, String filePath) {
        try {
            new File(filePath).getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(filePath, true);
            out.write(response);
            out.close();
        }
        catch (IOException e) {
            ReportService.ifLogMessage("saveResponseToFile", "Failed save data to: " + filePath + ", error: " + e.getMessage(), true);
        }
    }
}

