/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.base;

import com.vaadin.flow.plugin.base.CleanOptions;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;

public class CleanFrontendUtil {
    public static final String VAADIN = "vaadin";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "devDependencies";
    public static final String OVERRIDES = "overrides";

    public static void runCleaning(PluginAdapterBase adapter, CleanOptions options) throws CleanFrontendException {
        File frontendGeneratedFolder;
        File pnpmfile;
        if (FrontendUtils.isHillaUsed((File)adapter.frontendDirectory(), (ClassFinder)adapter.getClassFinder())) {
            options.withRemovePackageLock(false).withRemoveNodeModules(false);
        }
        if (options.isRemoveNodeModules()) {
            CleanFrontendUtil.removeNodeModules(adapter);
        }
        if (options.isRemovePackageLock()) {
            File lockFile = new File(adapter.npmFolder(), "pnpm-lock.yaml");
            if (!lockFile.exists()) {
                lockFile = new File(adapter.npmFolder(), "bun.lockb");
            }
            if (!lockFile.exists()) {
                lockFile = new File(adapter.npmFolder(), "package-lock.json");
            }
            if (lockFile.exists()) {
                lockFile.delete();
            }
        }
        if (options.isRemovePnpmFile() && (pnpmfile = new File(adapter.npmFolder(), ".pnpmfile.cjs")).exists()) {
            pnpmfile.delete();
        }
        if (adapter.generatedTsFolder().exists() && options.isRemoveGeneratedTSFolder()) {
            try {
                FileUtils.deleteDirectory((File)adapter.generatedTsFolder());
            }
            catch (IOException exception) {
                throw new CleanFrontendException("Failed to remove folder'" + adapter.generatedTsFolder().getAbsolutePath() + "'", exception);
            }
        }
        if ((frontendGeneratedFolder = new File(adapter.frontendDirectory(), "generated/")).exists() && options.isRemoveFrontendGeneratedFolder()) {
            try {
                FileUtils.deleteDirectory((File)frontendGeneratedFolder);
            }
            catch (IOException exception) {
                throw new CleanFrontendException("Failed to remove folder'" + frontendGeneratedFolder.getAbsolutePath() + "'", exception);
            }
        }
        try {
            File packageJsonFile = new File(adapter.npmFolder(), "package.json");
            if (packageJsonFile.exists() && options.isCleanPackageJson()) {
                JsonObject packageJson = Json.parse((String)FileUtils.readFileToString((File)packageJsonFile, (String)StandardCharsets.UTF_8.name()));
                CleanFrontendUtil.cleanupPackage(adapter, packageJson);
                FileUtils.write((File)packageJsonFile, (CharSequence)(JsonUtil.stringify((JsonValue)packageJson, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
            }
        }
        catch (IOException e) {
            throw new CleanFrontendException("Failed to clean 'package.json' file", e);
        }
        if (options.isRemoveDevBundle()) {
            CleanFrontendUtil.removeDevBundle(adapter);
        }
    }

    private static void removeDevBundle(PluginAdapterBase adapter) {
        CleanFrontendUtil.removeDevBundle(adapter, "src/main/bundles/");
        CleanFrontendUtil.removeDevBundle(adapter, "src/main/dev-bundle/");
    }

    private static void removeDevBundle(PluginAdapterBase adapter, String bundleLocation) {
        File bundleDir = new File(adapter.npmFolder(), bundleLocation);
        try {
            if (bundleDir.exists()) {
                FileUtils.deleteDirectory((File)bundleDir);
            }
        }
        catch (IOException exception) {
            adapter.logDebug("Exception removing dev-bundle", exception);
            adapter.logError("Failed to remove '" + bundleDir.getAbsolutePath() + "'. Please remove it manually.");
        }
    }

    private static void removeNodeModules(PluginAdapterBase adapter) {
        File nodeModules = new File(adapter.npmFolder(), "node_modules");
        try {
            FrontendUtils.deleteNodeModules((File)nodeModules);
        }
        catch (IOException exception) {
            adapter.logDebug("Exception removing node_modules", exception);
            adapter.logError("Failed to remove '" + nodeModules.getAbsolutePath() + "'. Please remove it manually.");
        }
    }

    private static void cleanupPackage(PluginAdapterBase adapter, JsonObject packageJson) {
        JsonObject dependencies = packageJson.getObject(DEPENDENCIES);
        JsonObject devDependencies = packageJson.getObject(DEV_DEPENDENCIES);
        JsonObject overridesSection = packageJson.getObject(OVERRIDES);
        if (packageJson.hasKey(VAADIN)) {
            JsonObject vaadin = packageJson.getObject(VAADIN);
            JsonObject vaadinDependencies = vaadin.getObject(DEPENDENCIES);
            JsonObject vaadinDevDependencies = vaadin.getObject(DEV_DEPENDENCIES);
            CleanFrontendUtil.cleanObject(dependencies, vaadinDependencies);
            CleanFrontendUtil.cleanObject(devDependencies, vaadinDevDependencies);
            CleanFrontendUtil.cleanObject(overridesSection, vaadinDependencies, false);
            packageJson.remove(VAADIN);
        }
        CleanFrontendUtil.cleanFrameworkBuildDependenices(adapter, dependencies);
        CleanFrontendUtil.cleanFrameworkBuildDependenices(adapter, devDependencies);
        packageJson.remove("hash");
    }

    private static void cleanObject(JsonObject target, JsonObject reference) {
        CleanFrontendUtil.cleanObject(target, reference, true);
    }

    private static void cleanObject(JsonObject target, JsonObject reference, boolean requireVersionsMatch) {
        if (target == null) {
            return;
        }
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : target.keys()) {
            if (!reference.hasKey(key) || requireVersionsMatch && !CleanFrontendUtil.versionsMatch(target, reference, key)) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            target.remove(key);
        }
    }

    private static boolean versionsMatch(JsonObject target, JsonObject reference, String key) {
        return target.getString(key).equals(reference.getString(key));
    }

    private static void cleanFrameworkBuildDependenices(PluginAdapterBase adapter, JsonObject dependencyObject) {
        if (dependencyObject == null) {
            return;
        }
        String buildTargetFolder = "./" + adapter.buildFolder();
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : dependencyObject.keys()) {
            if (!dependencyObject.getString(key).startsWith(buildTargetFolder)) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            dependencyObject.remove(key);
        }
    }

    public static class CleanFrontendException
    extends Exception {
        public CleanFrontendException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

