/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.testutil.AbstractTestBenchTest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewOrUITest
extends AbstractTestBenchTest {
    @Override
    protected String getTestPath() {
        Class<? extends Component> viewClass = this.getViewClass();
        try {
            if (viewClass != null) {
                return "/view/" + URLEncoder.encode(viewClass.getName(), StandardCharsets.UTF_8.name());
            }
            Class<? extends UI> uiClass = this.getUIClass();
            if (uiClass != null) {
                return "/run/" + URLEncoder.encode(uiClass.getName(), StandardCharsets.UTF_8.name());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Could not find a View or UI class for the test. Ensure " + ((Object)((Object)this)).getClass().getName().replaceFirst("IT$", "") + "View/UI exists  or override either getTestPath() or getViewClass()/getUIClass() in your test");
    }

    protected Class<? extends Component> getViewClass() {
        return this.findClass(Component.class, ((Object)((Object)this)).getClass().getName().replaceFirst("IT$", "View"));
    }

    protected Class<? extends UI> getUIClass() {
        return this.findClass(UI.class, ((Object)((Object)this)).getClass().getName().replaceFirst("IT$", "UI"));
    }

    private Class<?> findClass(Class<?> typeToFind, String classNameToFind) {
        try {
            Class<?> cls = Class.forName(classNameToFind);
            if (typeToFind.isAssignableFrom(cls)) {
                return cls;
            }
        }
        catch (Exception e) {
            ViewOrUITest.getLogger().debug("{} for {} not found", (Object)typeToFind.getSimpleName(), (Object)((Object)((Object)this)).getClass().getName());
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ViewOrUITest.class.getName());
    }
}

