/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.source;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.vaadin.flow.component.map.configuration.Feature;
import com.vaadin.flow.component.map.configuration.source.Source;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VectorSource
extends Source {
    private final List<Feature> features = new ArrayList<Feature>();

    public VectorSource() {
        this(new Options());
    }

    public VectorSource(Options options) {
        super(options);
    }

    @Override
    public String getType() {
        return "ol/source/Vector";
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public void addFeature(Feature feature) {
        Objects.requireNonNull(feature);
        this.features.add(feature);
        this.addChild(feature);
    }

    public void removeFeature(Feature feature) {
        Objects.requireNonNull(feature);
        this.features.remove(feature);
        this.removeChild(feature);
    }

    public void removeAllFeatures() {
        for (Feature feature : (Feature[])this.getFeatures().toArray(Feature[]::new)) {
            this.removeFeature(feature);
        }
    }

    public static class Options
    extends Source.Options {
    }
}

