/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

public class LocalDateTimeRenderer<SOURCE>
extends BasicRenderer<SOURCE, LocalDateTime> {
    private SerializableSupplier<DateTimeFormatter> formatter;
    private String nullRepresentation;

    public LocalDateTimeRenderer(ValueProvider<SOURCE, LocalDateTime> valueProvider) {
        this(valueProvider, (SerializableSupplier<DateTimeFormatter>)(SerializableSupplier & Serializable)() -> DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.SHORT), "");
    }

    public LocalDateTimeRenderer(ValueProvider<SOURCE, LocalDateTime> valueProvider, SerializableSupplier<DateTimeFormatter> formatter) {
        this(valueProvider, formatter, "");
    }

    public LocalDateTimeRenderer(ValueProvider<SOURCE, LocalDateTime> valueProvider, SerializableSupplier<DateTimeFormatter> formatter, String nullRepresentation) {
        super(valueProvider);
        if (formatter == null) {
            throw new IllegalArgumentException("formatter may not be null");
        }
        this.formatter = formatter;
        this.nullRepresentation = nullRepresentation;
    }

    public LocalDateTimeRenderer(ValueProvider<SOURCE, LocalDateTime> valueProvider, String formatPattern) {
        this(valueProvider, formatPattern, Locale.getDefault());
    }

    public LocalDateTimeRenderer(ValueProvider<SOURCE, LocalDateTime> valueProvider, String formatPattern, Locale locale) {
        this(valueProvider, formatPattern, locale, "");
    }

    public LocalDateTimeRenderer(ValueProvider<SOURCE, LocalDateTime> valueProvider, String formatPattern, Locale locale, String nullRepresentation) {
        super(valueProvider);
        if (formatPattern == null) {
            throw new IllegalArgumentException("format pattern may not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale may not be null");
        }
        this.formatter = (SerializableSupplier & Serializable)() -> DateTimeFormatter.ofPattern(formatPattern, locale);
        this.nullRepresentation = nullRepresentation;
    }

    @Override
    protected String getFormattedValue(LocalDateTime dateTime) {
        return dateTime == null ? this.nullRepresentation : ((DateTimeFormatter)this.formatter.get()).format(dateTime);
    }
}

